/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.bot;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Activity;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.NodeInformation;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class ExprPresence
extends SimpleExpression<Activity> {
    private int pattern;
    private Expression<String> exprInput;
    private Expression<String> exprURL;
    private NodeInformation node;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.exprInput = exprs[0];
        this.node = new NodeInformation();
        if (matchedPattern == 3) {
            this.exprURL = exprs[1];
        }
        return true;
    }

    protected Activity @NotNull [] get(@NotNull Event e) {
        String url;
        String input = (String)this.exprInput.getSingle(e);
        String string = url = this.exprURL == null ? null : (String)this.exprURL.getSingle(e);
        if (input == null) {
            return new Activity[0];
        }
        Activity activity = null;
        switch (this.pattern) {
            case 0: {
                activity = Activity.listening(input);
                break;
            }
            case 1: {
                activity = Activity.watching(input);
                break;
            }
            case 2: {
                activity = Activity.playing(input);
                break;
            }
            case 3: {
                if (url == null) {
                    DiSky.getErrorHandler().exception(e, "The streaming URL cannot be null or not set!");
                }
                if (!Activity.isValidStreamingUrl(url)) {
                    DiSky.getErrorHandler().exception(e, "The streaming URL specified for the presence is NOT valid! (Input: " + url + ")");
                }
                activity = Activity.streaming(input, url);
                break;
            }
            case 4: {
                activity = Activity.competing(input);
            }
            case 5: {
                activity = Activity.customStatus(input);
            }
        }
        return new Activity[]{activity};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Activity> getReturnType() {
        return Activity.class;
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        switch (this.pattern) {
            case 0: {
                return "listening " + this.exprInput.toString(e, debug);
            }
            case 1: {
                return "watching " + this.exprInput.toString(e, debug);
            }
            case 2: {
                return "playing " + this.exprInput.toString(e, debug);
            }
            case 3: {
                return "streaming " + this.exprInput.toString(e, debug) + " with url " + this.exprURL.toString(e, debug);
            }
            case 4: {
                return "competing " + this.exprInput.toString(e, debug);
            }
            case 5: {
                return "custom status " + this.exprInput.toString(e, debug);
            }
        }
        return "";
    }

    static {
        Skript.registerExpression(ExprPresence.class, Activity.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"listening [to] %string%", "watching [to] %string%", "playing [to] %string%", "streaming [to] %string% with [the] url %string%", "competing [to] %string%", "custom status [of] %string%"});
    }
}

