/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.embeds;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.EmbedBuilder;
import net.itsthesky.disky.DiSky;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class EffAddField
extends Effect {
    private Expression<String> exprName;
    private Expression<String> exprDesc;
    private Expression<EmbedBuilder> exprEmbed;
    private boolean isInline;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprName = exprs[0];
        this.exprDesc = exprs[1];
        this.exprEmbed = exprs[2];
        this.isInline = matchedPattern != 0;
        return true;
    }

    protected void execute(@NotNull Event e) {
        String name = (String)this.exprName.getSingle(e);
        String desc = (String)this.exprDesc.getSingle(e);
        EmbedBuilder embed2 = (EmbedBuilder)this.exprEmbed.getSingle(e);
        if (name == null || desc == null || embed2 == null) {
            return;
        }
        if (name.length() > 256) {
            DiSky.getErrorHandler().exception(e, new RuntimeException("The title of a field cannot be bigger than 256 characters. The one you're trying to set is '" + name.length() + "' length!"));
            return;
        }
        if (desc.length() > 1024) {
            DiSky.getErrorHandler().exception(e, new RuntimeException("The value of a field cannot be bigger than 1024 characters. The one you're trying to set is '" + desc.length() + "' length!"));
            return;
        }
        embed2.addField(name, desc, this.isInline);
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        return "add field with named " + this.exprName.toString(e, debug) + " with description " + this.exprDesc.toString(e, debug) + " to fields of " + this.exprEmbed.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffAddField.class, (String[])new String[]{"add field (named|with name) %string% [and] with [the] value %string% to [fields of] %embedbuilder%", "add inline field (named|with name) %string% [and] with [the] value %string% to [fields of] %embedbuilder%"});
    }
}

