/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.events;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import java.util.Date;
import net.dv8tion.jda.api.entities.ScheduledEvent;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.elements.properties.events.SimpleScheduledEventExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="End date of Scheduled Event")
@Description(value={"Get the end date of a scheduled event.", "Can be null if the event is made from a channel and not an external place."})
@Since(value={"4.8.0"})
public class EventEndDate
extends SimpleScheduledEventExpression<ch.njol.skript.util.Date> {
    @NotNull
    protected String getPropertyName() {
        return "scheduled event end date";
    }

    @Nullable
    public ch.njol.skript.util.Date convert(ScheduledEvent scheduledEvent) {
        if (scheduledEvent.getEndTime() == null) {
            return null;
        }
        return new ch.njol.skript.util.Date(scheduledEvent.getEndTime().toInstant().toEpochMilli());
    }

    @Override
    public RestAction<?> change(ScheduledEvent entity, Object[] delta) {
        ch.njol.skript.util.Date date = (ch.njol.skript.util.Date)delta[0];
        if (date == null) {
            return null;
        }
        return entity.getManager().setEndTime(new Date(date.getTime()).toInstant());
    }

    @Override
    @NotNull
    public Class<? extends ch.njol.skript.util.Date> getReturnType() {
        return ch.njol.skript.util.Date.class;
    }

    static {
        EventEndDate.register(EventEndDate.class, ch.njol.skript.util.Date.class, (String)"scheduled [event] end date", (String)"scheduledevent");
    }
}

