/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.events;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import net.dv8tion.jda.api.entities.ScheduledEvent;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.elements.properties.events.SimpleScheduledEventExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Location of Scheduled Event")
@Description(value={"Get the location of a scheduled event.", "Returns the specified place if the event is external, or the audio channel's ID."})
@Since(value={"4.8.0"})
public class EventLocation
extends SimpleScheduledEventExpression<Object> {
    @NotNull
    protected String getPropertyName() {
        return "scheduled event location";
    }

    @Nullable
    public Object convert(ScheduledEvent scheduledEvent) {
        String location = scheduledEvent.getLocation();
        if (scheduledEvent.getType().isChannel()) {
            return scheduledEvent.getJDA().getChannelById(AudioChannel.class, location);
        }
        return location;
    }

    @Override
    public RestAction<?> change(ScheduledEvent entity, Object[] delta) {
        Object location = delta[0];
        if (location instanceof AudioChannel) {
            AudioChannel audioChannel = (AudioChannel)location;
            return entity.getManager().setLocation(audioChannel);
        }
        return entity.getManager().setLocation((String)location);
    }

    @Override
    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        EventLocation.register(EventLocation.class, Object.class, (String)"scheduled [event] location", (String)"scheduledevent");
    }
}

