/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.events;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import java.util.Date;
import net.dv8tion.jda.api.entities.ScheduledEvent;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.elements.properties.events.SimpleScheduledEventExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Start date of Scheduled Event")
@Description(value={"Get the start date of a scheduled event. Cannot be null."})
@Since(value={"4.8.0"})
public class EventStartDate
extends SimpleScheduledEventExpression<ch.njol.skript.util.Date> {
    @NotNull
    protected String getPropertyName() {
        return "scheduled event date";
    }

    @Nullable
    public ch.njol.skript.util.Date convert(ScheduledEvent scheduledEvent) {
        return new ch.njol.skript.util.Date(scheduledEvent.getStartTime().toInstant().toEpochMilli());
    }

    @Override
    public RestAction<?> change(ScheduledEvent entity, Object[] delta) {
        ch.njol.skript.util.Date date = (ch.njol.skript.util.Date)delta[0];
        if (date == null) {
            return null;
        }
        return entity.getManager().setStartTime(new Date(date.getTime()).toInstant());
    }

    @Override
    @NotNull
    public Class<? extends ch.njol.skript.util.Date> getReturnType() {
        return ch.njol.skript.util.Date.class;
    }

    static {
        EventStartDate.register(EventStartDate.class, ch.njol.skript.util.Date.class, (String)"scheduled [event] [start] date", (String)"scheduledevent");
    }
}

