/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.events;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import net.dv8tion.jda.api.entities.ScheduledEvent;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.elements.properties.events.SimpleScheduledEventExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Status of Scheduled Event")
@Description(value={"Get the status of a scheduled event between:", "- Scheduled", "- Active", "- Completed", "- Cancelled"})
@Since(value={"4.8.0"})
public class EventStatus
extends SimpleScheduledEventExpression<String> {
    @NotNull
    protected String getPropertyName() {
        return "scheduled event status";
    }

    @Nullable
    public String convert(ScheduledEvent scheduledEvent) {
        return scheduledEvent.getStatus().name().toLowerCase().replace("_", " ");
    }

    @Override
    public RestAction<?> change(ScheduledEvent entity, Object[] delta) {
        String raw = delta[0] == null ? null : ((String)delta[0]).toUpperCase().replace(" ", "_");
        ScheduledEvent.Status status = ScheduledEvent.Status.valueOf(raw);
        return entity.getManager().setStatus(status);
    }

    @Override
    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        EventStatus.register(EventStatus.class, String.class, (String)"scheduled [event] status", (String)"scheduledevent");
    }
}

