/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.events;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import net.dv8tion.jda.api.entities.ScheduledEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Type of Scheduled Event")
@Description(value={"Get the type of a scheduled event.", "It can either be 'voice/stage instance' or 'external' according to the type of the event."})
@Since(value={"4.8.0"})
public class EventType
extends SimplePropertyExpression<ScheduledEvent, String> {
    @NotNull
    protected String getPropertyName() {
        return "scheduled event type";
    }

    @Nullable
    public String convert(ScheduledEvent scheduledEvent) {
        return scheduledEvent.getType().name().toLowerCase().replace("_", " ");
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        EventType.register(EventType.class, String.class, (String)"scheduled [event] type", (String)"scheduledevent");
    }
}

