/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.guilds;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Locale;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.managers.GuildManager;
import net.itsthesky.disky.api.skript.INodeHolder;
import net.itsthesky.disky.elements.changers.IAsyncChangeableExpression;
import net.itsthesky.disky.elements.properties.guilds.GuildProperty;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Guild Verification Level")
@Description(value={"Represent the verification level of the guild. It can either be:", "- None", "- Low", "- Medium", "- High", "- Very High"})
@Examples(value={"reply with verification level of event-guild"})
public class GuildVerificationLevel
extends GuildProperty<String>
implements IAsyncChangeableExpression,
INodeHolder {
    private Node node;

    @Override
    public String converting(Guild guild) {
        return guild.getVerificationLevel().name().toLowerCase(Locale.ROOT).replace("_", " ");
    }

    public Class<?> @Nullable [] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(@NotNull Event event, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        this.change(event, delta, mode, false);
    }

    @Override
    public void changeAsync(Event e, Object[] delta, Changer.ChangeMode mode) {
        this.change(e, delta, mode, true);
    }

    private void change(Event e, Object[] delta, Changer.ChangeMode mode, boolean async) {
        Guild.VerificationLevel level;
        if (delta == null || delta.length == 0 || delta[0] == null) {
            return;
        }
        Guild guild = (Guild)this.getExpr().getSingle(e);
        String value = (String)delta[0];
        if (value == null || guild == null) {
            return;
        }
        try {
            level = Guild.VerificationLevel.valueOf(value.toUpperCase(Locale.ROOT).replace(" ", "_"));
        }
        catch (IllegalArgumentException ex) {
            DiSkyRuntimeHandler.error(new IllegalArgumentException("The verification level specified is not valid!"), this.node);
            return;
        }
        GuildManager action = guild.getManager().setVerificationLevel(level);
        if (async) {
            action.complete();
        } else {
            action.queue();
        }
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.node = this.getParser().getNode();
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Override
    @NotNull
    public Node getNode() {
        return this.node;
    }

    static {
        GuildVerificationLevel.register(GuildVerificationLevel.class, String.class, "verification level[s]");
    }
}

