/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.messages;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import org.jetbrains.annotations.NotNull;

@Name(value="Message Embeds")
@Description(value={"Get every embeds of a specific messages. Keep in mind only webhook are allowed to send more than one embed!"})
@Examples(value={"embeds of event-message"})
public class MessageEmbeds
extends MultiplyPropertyExpression<Message, EmbedBuilder> {
    protected EmbedBuilder[] convert(Message t) {
        return (EmbedBuilder[])t.getEmbeds().stream().map(EmbedBuilder::new).toArray(EmbedBuilder[]::new);
    }

    @Override
    @NotNull
    public Class<? extends EmbedBuilder> getReturnType() {
        return EmbedBuilder.class;
    }

    @Override
    protected String getPropertyName() {
        return "embeds";
    }

    static {
        MessageEmbeds.register(MessageEmbeds.class, EmbedBuilder.class, "[discord] [message] embeds", "message");
    }
}

