/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.messages;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import net.dv8tion.jda.api.entities.Message;
import org.jetbrains.annotations.NotNull;

@Name(value="Is Ephemeral")
@Description(value={"Return true if the message was ephemeral, e.g. private / hidden.", "Action on hidden messages are limited."})
@Examples(value={"event-message is ephemeral"})
public class MessageIsEphemeral
extends PropertyCondition<Message> {
    public boolean check(@NotNull Message msg) {
        return msg.getFlags().contains((Object)Message.MessageFlag.EPHEMERAL);
    }

    protected String getPropertyName() {
        return "ephemeral";
    }

    static {
        MessageIsEphemeral.register(MessageIsEphemeral.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.BE, (String)"ephemeral", (String)"message");
    }
}

