/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.messages;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import org.jetbrains.annotations.NotNull;

@Name(value="Message Text Channels")
@Description(value={"Get every mentioned text channels in a message."})
@Examples(value={"mentioned text channels of event-message"})
public class MessageMentionedChannels
extends MultiplyPropertyExpression<Message, TextChannel> {
    @Override
    @NotNull
    public Class<? extends TextChannel> getReturnType() {
        return TextChannel.class;
    }

    @Override
    protected String getPropertyName() {
        return "mentioned channels";
    }

    protected TextChannel[] convert(Message t) {
        return t.getMentions().getChannels().toArray(new TextChannel[0]);
    }

    static {
        MessageMentionedChannels.register(MessageMentionedChannels.class, TextChannel.class, "[discord] [message] mentioned text channels", "message");
    }
}

