/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.messages;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import org.jetbrains.annotations.NotNull;

@Name(value="Message Mentioned Members")
@Description(value={"Get every mentioned members in a message. If the message doesn't come from a guild it will return an empty array!"})
@Examples(value={"mentioned members of event-message"})
public class MessageMentionedMembers
extends MultiplyPropertyExpression<Message, Member> {
    @Override
    @NotNull
    public Class<? extends Member> getReturnType() {
        return Member.class;
    }

    @Override
    protected String getPropertyName() {
        return "mentioned members";
    }

    protected Member[] convert(Message message2) {
        return message2.getMentions().getMembers().toArray(new Member[0]);
    }

    static {
        MessageMentionedMembers.register(MessageMentionedMembers.class, Member.class, "[discord] [message] mentioned members", "message");
    }
}

