/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.messages;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Role;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import org.jetbrains.annotations.NotNull;

@Name(value="Message Mentioned Roles")
@Description(value={"Get every mentioned Roles in a message. If the message doesn't come from a guild it will return an empty array!"})
@Examples(value={"mentioned roles of event-message"})
public class MessageMentionedRoles
extends MultiplyPropertyExpression<Message, Role> {
    @Override
    @NotNull
    public Class<? extends Role> getReturnType() {
        return Role.class;
    }

    @Override
    protected String getPropertyName() {
        return "mentioned roles";
    }

    protected Role[] convert(Message message2) {
        return message2.getMentions().getRoles().toArray(new Role[0]);
    }

    static {
        MessageMentionedRoles.register(MessageMentionedRoles.class, Role.class, "[discord] [message] mentioned roles", "message");
    }
}

