/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.messages;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import org.jetbrains.annotations.NotNull;

@Name(value="Message Voice Channels")
@Description(value={"Get every mentioned voice channels in a message."})
@Examples(value={"mentioned voice channels of event-message"})
public class MessageMentionedVoiceChannels
extends MultiplyPropertyExpression<Message, VoiceChannel> {
    @Override
    @NotNull
    public Class<? extends VoiceChannel> getReturnType() {
        return VoiceChannel.class;
    }

    @Override
    protected String getPropertyName() {
        return "mentioned channels";
    }

    protected VoiceChannel[] convert(Message t) {
        return t.getMentions().getChannels().toArray(new VoiceChannel[0]);
    }

    static {
        MessageMentionedVoiceChannels.register(MessageMentionedVoiceChannels.class, VoiceChannel.class, "[discord] [message] mentioned voice channels", "message");
    }
}

