/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.tags;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.channel.concrete.ForumChannel;
import net.dv8tion.jda.api.entities.channel.forums.ForumTag;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Get Tag")
@Description(value={"Get a tag from a forum channel using its name."})
@Examples(value={"tag named \"v4\" from forum channel with id \"000\""})
@Since(value={"4.4.4"})
public class GetTag
extends SimpleExpression<ForumTag> {
    private Expression<String> exprName;
    private Expression<ForumChannel> exprChannel;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprName = exprs[0];
        this.exprChannel = exprs[1];
        return true;
    }

    protected ForumTag @NotNull [] get(@NotNull Event e) {
        String name = EasyElement.parseSingle(this.exprName, e);
        ForumChannel channel = EasyElement.parseSingle(this.exprChannel, e);
        if (name == null || channel == null) {
            return new ForumTag[0];
        }
        return new ForumTag[]{channel.getAvailableTags().stream().filter(tag -> tag.getName().equals(name)).findFirst().orElse(null)};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ForumTag> getReturnType() {
        return ForumTag.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "tag named " + this.exprName.toString(e, debug) + " from " + this.exprChannel.toString(e, debug);
    }

    static {
        Skript.registerExpression(GetTag.class, ForumTag.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[forum] tag ((from|with) name|named) %string% (of|from|in) %forumchannel%"});
    }
}

