/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.tags;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.concrete.ForumChannel;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.forums.BaseForumTag;
import net.dv8tion.jda.api.entities.channel.forums.ForumTag;
import net.dv8tion.jda.api.entities.channel.forums.ForumTagSnowflake;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import net.itsthesky.disky.elements.changers.IAsyncChangeableExpression;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Post / Forum Tags")
@Description(value={"Get all tags of a forum channel or a thread channel.", "You can also add or remove tags from a thread channel using this expression.", "You must add the tag to the forum itself before adding it to the post."})
@Examples(value={"set {_tags::*} to tags of event-forumchannel", "add new tag named \"resolved\" with reaction \"x\" to tags of forum with id \"000\""})
public class ThreadTags
extends MultiplyPropertyExpression<Object, BaseForumTag>
implements IAsyncChangeableExpression {
    private Node node;

    @Override
    public boolean init(Expression<?> @NotNull [] expr, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.node = this.getParser().getNode();
        return super.init(expr, matchedPattern, isDelayed, parseResult);
    }

    public Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.RESET) {
            return new Class[]{String[].class, String.class, BaseForumTag.class, BaseForumTag[].class};
        }
        return new Class[0];
    }

    @Override
    public void changeAsync(Event e, Object[] delta, Changer.ChangeMode mode) {
        this.change(e, delta, mode, true);
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        this.change(event, delta, mode, false);
    }

    public void change(@NotNull Event e, @NotNull Object[] delta, @NotNull Changer.ChangeMode mode, boolean async) {
        Object action;
        ForumChannel channel;
        if (!EasyElement.isValid(delta)) {
            return;
        }
        Object entity = EasyElement.parseSingle(this.getExpr(), e, null);
        if (!(entity instanceof ThreadChannel) && !(entity instanceof ForumChannel)) {
            return;
        }
        if (entity instanceof ThreadChannel && !((ThreadChannel)entity).getParentChannel().getType().equals((Object)ChannelType.FORUM)) {
            return;
        }
        ForumChannel forumChannel = channel = entity instanceof ThreadChannel ? ((ThreadChannel)entity).getParentChannel().asForumChannel() : (ForumChannel)entity;
        if (entity instanceof ThreadChannel) {
            ThreadChannel threadChannel = entity;
            ArrayList<ForumTag> current = new ArrayList<ForumTag>(threadChannel.getAppliedTags());
            ArrayList<Object> parsedTags = new ArrayList<Object>();
            for (Object in : delta) {
                if (in instanceof String) {
                    List<ForumTag> tag2;
                    String input = (String)in;
                    Matcher numeral = Pattern.compile("^([0-9]+)$").matcher(input);
                    if (numeral.matches()) {
                        tag2 = channel.getAvailableTagById(input);
                        if (tag2 == null) {
                            DiSkyRuntimeHandler.error(new IllegalArgumentException("The tag with ID " + input + " doesn't exist in the channel " + channel.getName() + "!"), this.node);
                            continue;
                        }
                        parsedTags.add(tag2);
                        continue;
                    }
                    tag2 = channel.getAvailableTagsByName(input, true);
                    if (tag2.isEmpty()) {
                        DiSkyRuntimeHandler.error(new IllegalArgumentException("The tag with name " + input + " doesn't exist in the channel " + channel.getName() + "!"), this.node);
                        continue;
                    }
                    parsedTags.add((ForumTag)tag2.get(0));
                    continue;
                }
                if (!(in instanceof BaseForumTag)) continue;
                parsedTags.add((ForumTag)in);
            }
            switch (mode) {
                case ADD: {
                    current.addAll(parsedTags);
                    break;
                }
                case REMOVE: {
                    current.removeAll(parsedTags);
                    break;
                }
                case SET: {
                    current.clear();
                    current.addAll(parsedTags);
                    break;
                }
                case RESET: {
                    current.clear();
                }
            }
            action = threadChannel.getManager().setAppliedTags(current.stream().map(tag -> ForumTagSnowflake.fromId(tag.getIdLong())).collect(Collectors.toList()));
        } else {
            ForumChannel forumChannel2 = entity;
            ArrayList<ForumTag> current = new ArrayList<ForumTag>(forumChannel2.getAvailableTags());
            List<BaseForumTag> baseForumTags = Arrays.asList((BaseForumTag[])delta);
            switch (mode) {
                case ADD: {
                    current.addAll(baseForumTags);
                    break;
                }
                case REMOVE: {
                    current.removeAll(baseForumTags);
                    break;
                }
                case SET: {
                    current.clear();
                    current.addAll(baseForumTags);
                    break;
                }
                case RESET: {
                    current.clear();
                }
            }
            action = forumChannel2.getManager().setAvailableTags(current);
        }
        if (async) {
            action.complete();
        } else {
            action.queue();
        }
    }

    @Override
    @NotNull
    public Class<? extends ForumTag> getReturnType() {
        return ForumTag.class;
    }

    @Override
    protected String getPropertyName() {
        return "tags";
    }

    protected ForumTag[] convert(Object obj) {
        if (obj instanceof ForumChannel) {
            return ((ForumChannel)obj).getAvailableTags().toArray(new ForumTag[0]);
        }
        if (obj instanceof ThreadChannel) {
            return ((ThreadChannel)obj).getAppliedTags().toArray(new ForumTag[0]);
        }
        Skript.error((String)("Cannot get tags from a " + obj.getClass().getName()));
        return new ForumTag[0];
    }

    static {
        ThreadTags.register(ThreadTags.class, BaseForumTag.class, "tags", "threadchannel/forumchannel");
    }
}

