/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.automod;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.time.Duration;
import net.dv8tion.jda.api.entities.automod.AutoModResponse;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewRuleResponse
extends SimpleExpression<AutoModResponse> {
    private int pattern;
    private Expression<String> exprReason;
    private Expression<Channel> exprChannel;
    private Expression<Timespan> exprTime;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        switch (this.pattern) {
            case 1: {
                this.exprReason = exprs[0];
                break;
            }
            case 2: {
                this.exprChannel = exprs[0];
                break;
            }
            case 3: {
                this.exprTime = exprs[0];
            }
        }
        return true;
    }

    protected AutoModResponse @NotNull [] get(@NotNull Event e) {
        switch (this.pattern) {
            case 0: {
                return new AutoModResponse[]{AutoModResponse.blockMemberInteraction()};
            }
            case 1: {
                return new AutoModResponse[]{AutoModResponse.blockMessage(EasyElement.parseSingle(this.exprReason, e))};
            }
            case 2: {
                Channel channel = EasyElement.parseSingle(this.exprChannel, e);
                if (!channel.getType().isGuild() || !channel.getType().isMessage()) {
                    Skript.error((String)("The channel '" + channel.getName() + "' is not a guild & text channel, so it cannot be used in an automod rule!"));
                    return new AutoModResponse[0];
                }
                return new AutoModResponse[]{AutoModResponse.sendAlert((GuildMessageChannel)channel)};
            }
            case 3: {
                Timespan timespan = EasyElement.parseSingle(this.exprTime, e);
                if (timespan.getAs(Timespan.TimePeriod.TICK) <= 0L) {
                    Skript.error((String)("The timespan '" + timespan.toString() + "' is not valid, it must be greater than 0!"));
                    return new AutoModResponse[0];
                }
                return new AutoModResponse[]{AutoModResponse.timeoutMember(Duration.ofMillis(timespan.getAs(Timespan.TimePeriod.MILLISECOND)))};
            }
        }
        return new AutoModResponse[0];
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends AutoModResponse> getReturnType() {
        return AutoModResponse.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        switch (this.pattern) {
            case 0: {
                return "block member interaction";
            }
            case 1: {
                return "block message with reason " + this.exprReason.toString(e, debug);
            }
            case 2: {
                return "send alert in channel " + this.exprChannel.toString(e, debug);
            }
            case 3: {
                return "timeout member for " + this.exprTime.toString(e, debug);
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.pattern);
    }

    static {
        Skript.registerExpression(NewRuleResponse.class, AutoModResponse.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"block [member] interaction", "block message[s] [with [the] [reason] %-string%]", "send [an] alert (in|at|to) [the] [channel] %channel/textchannel%", "timeout [the] member [for] %timespan%"});
    }
}

