/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.message;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.io.File;
import java.util.ArrayList;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.selections.SelectMenu;
import net.dv8tion.jda.api.interactions.components.text.TextInput;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessagePollBuilder;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.components.core.ComponentRow;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Inline Rich Message Builder")
@Description(value={"Create a new rich message in one line only.", "WARNING: This could slow a lot the Skript's parsing time if used too many times!", "We still recommend to use the create message section instead!", "You can also use the second pattern to send component-only messages."})
@Examples(value={"reply with message \"hello world\" with embed last embed with components {_row}", "post components new danger button with id \"id\" named \"Hey\" to event-channel"})
@Since(value={"4.4.1, 4.4.3 (component-only)"})
public class InlineMessageBuilder
extends SimpleExpression<MessageCreateBuilder> {
    private Expression<Object> exprBase;
    private Expression<EmbedBuilder> exprEmbeds;
    private Expression<Object> exprRows;
    private Expression<String> exprFiles;
    private Expression<MessagePollBuilder> exprPoll;
    private boolean isComponentOnly;
    private boolean isSilent;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.isComponentOnly = matchedPattern == 1;
        this.isSilent = parseResult.hasTag("silent");
        this.exprBase = exprs[0];
        if (!this.isComponentOnly) {
            this.exprEmbeds = exprs[1];
            this.exprRows = exprs[2];
            this.exprFiles = exprs[3];
            this.exprPoll = exprs[4];
        }
        return true;
    }

    @Nullable
    protected MessageCreateBuilder[] get(@NotNull Event e) {
        EmbedBuilder[] embeds = EasyElement.parseList(this.exprEmbeds, e, null);
        Object[] rows = EasyElement.parseList(this.exprRows, e, null);
        String[] files = EasyElement.parseList(this.exprFiles, e, null);
        MessagePollBuilder poll = EasyElement.parseSingle(this.exprPoll, e, null);
        MessageCreateBuilder builder = new MessageCreateBuilder().setSuppressedNotifications(this.isSilent);
        if (this.isComponentOnly) {
            Object[] baseRows = EasyElement.parseList(this.exprBase, e, new Object[0]);
            ArrayList<ActionRow> actionRows = new ArrayList<ActionRow>();
            for (Object row2 : baseRows) {
                if (row2 instanceof ComponentRow) {
                    actionRows.add(((ComponentRow)row2).asActionRow());
                    continue;
                }
                if (row2 instanceof Button) {
                    actionRows.add(ActionRow.of((Button)row2));
                    continue;
                }
                if (row2 instanceof SelectMenu.Builder) {
                    actionRows.add(ActionRow.of(new ItemComponent[]{((SelectMenu.Builder)row2).build()}));
                    continue;
                }
                if (!(row2 instanceof TextInput)) continue;
                actionRows.add(ActionRow.of((TextInput)row2));
            }
            return new MessageCreateBuilder[]{(MessageCreateBuilder)builder.setComponents(actionRows)};
        }
        Object[] base = EasyElement.parseSingle(this.exprBase, e, null);
        if (base instanceof String) {
            builder.setContent((String)base);
        } else if (base instanceof EmbedBuilder) {
            builder.setEmbeds(((EmbedBuilder)base).build());
        } else if (base instanceof MessagePollBuilder) {
            builder.setPoll(((MessagePollBuilder)base).build());
        }
        if (embeds != null) {
            for (EmbedBuilder embed2 : embeds) {
                builder.addEmbeds(embed2.build());
            }
        }
        if (files != null) {
            for (String path : files) {
                builder.addFiles(FileUpload.fromData(new File(path)));
            }
        }
        if (poll != null) {
            builder.setPoll(poll.build());
        }
        if (rows != null) {
            ArrayList<ActionRow> actionRows = new ArrayList<ActionRow>();
            for (Object obj : rows) {
                if (obj instanceof Button) {
                    actionRows.add(ActionRow.of((Button)obj));
                    continue;
                }
                if (obj instanceof ComponentRow) {
                    actionRows.add(((ComponentRow)obj).asActionRow());
                    continue;
                }
                if (obj instanceof SelectMenu.Builder) {
                    actionRows.add(ActionRow.of(new ItemComponent[]{((SelectMenu.Builder)obj).build()}));
                    continue;
                }
                if (!(obj instanceof TextInput.Builder)) continue;
                actionRows.add(ActionRow.of(((TextInput.Builder)obj).build()));
            }
            builder.setComponents(actionRows);
        }
        return new MessageCreateBuilder[]{builder};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends MessageCreateBuilder> getReturnType() {
        return MessageCreateBuilder.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "rich message with content " + this.exprBase.toString(e, debug);
    }

    static {
        Skript.registerExpression(InlineMessageBuilder.class, MessageCreateBuilder.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[rich] [:silent] message %string/embedbuilder/messagepollbuilder% [with embed[s] %-embedbuilders%] [with (component[s]|row[s]) %-rows/buttons/dropdowns%] [with (file|attachment)[s] %-strings%] [with poll %-messagepollbuilder%]", "rich [:silent] component[s] %rows/buttons/dropdowns%"});
    }
}

