/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.message;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import net.itsthesky.disky.elements.sections.message.CreateMessage;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Message Builder Attachments")
@Description(value={"Attachments of a message builder", "Supports SkImage's images if the addon is installed.", "See also: 'Create (rich) Message'"})
public class MessageAttachments
extends MultiplyPropertyExpression<MessageCreateBuilder, Object> {
    @Override
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentSection(CreateMessage.class)) {
            Skript.error((String)"You can only use the 'message attachments' expression inside a 'create message' section");
            return false;
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    public Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            if (DiSky.isSkImageInstalled()) {
                return new Class[]{String.class, String[].class, BufferedImage.class, BufferedImage[].class};
            }
            return new Class[]{String.class, String[].class};
        }
        return new Class[0];
    }

    public void change(@NotNull Event e, @NotNull Object[] delta, @NotNull Changer.ChangeMode mode) {
        if (!EasyElement.isValid(delta)) {
            return;
        }
        MessageCreateBuilder builder = EasyElement.parseSingle(this.getExpr(), e, null);
        if (builder == null) {
            return;
        }
        ArrayList<FileUpload> uploads = new ArrayList<FileUpload>();
        int imageCount = 1;
        for (Object file : delta) {
            if (file instanceof String) {
                File f = new File((String)file);
                if (!f.exists()) continue;
                uploads.add(FileUpload.fromData(f));
                continue;
            }
            if (!(file instanceof BufferedImage)) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)((BufferedImage)file), "png", baos);
            }
            catch (IOException ex) {
                Skript.error((String)"Unable to convert image to byte array:");
                ex.printStackTrace();
                continue;
            }
            byte[] bytes = baos.toByteArray();
            uploads.add(FileUpload.fromData(bytes, "image" + imageCount + ".png"));
            ++imageCount;
        }
        builder.addFiles(uploads);
    }

    @Override
    @NotNull
    public Class<?> getReturnType() {
        return Object.class;
    }

    @Override
    protected String getPropertyName() {
        return "attachments";
    }

    @Override
    protected Object[] convert(MessageCreateBuilder messageCreateBuilder) {
        return messageCreateBuilder.getAttachments().stream().map(FileUpload::getName).toArray(String[]::new);
    }

    static {
        MessageAttachments.register(MessageAttachments.class, Object.class, "(attachment|image)[s]", "messagecreatebuilder");
    }
}

