/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.message;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.sections.message.CreateMessage;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Message Builder Content")
@Description(value={"Text content of a message builder", "See also: 'Create (rich) Message'"})
public class MessageContent
extends SimplePropertyExpression<MessageCreateBuilder, String> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentSection(CreateMessage.class)) {
            Skript.error((String)"You can only use the 'builder content' expression inside a 'create message' section");
            return false;
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    public Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{String.class};
        }
        return new Class[0];
    }

    public void change(@NotNull Event e, @NotNull Object[] delta, @NotNull Changer.ChangeMode mode) {
        if (!EasyElement.isValid(delta)) {
            return;
        }
        String content = (String)delta[0];
        MessageCreateBuilder builder = EasyElement.parseSingle(this.getExpr(), e, null);
        if (content == null || builder == null) {
            return;
        }
        builder.setContent(content);
    }

    @NotNull
    protected String getPropertyName() {
        return "content";
    }

    @Nullable
    public String convert(MessageCreateBuilder messageCreateBuilder) {
        return messageCreateBuilder.getContent();
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        MessageContent.register(MessageContent.class, String.class, (String)"content", (String)"messagecreatebuilder");
    }
}

