/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.message;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import java.util.LinkedList;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.selections.SelectMenu;
import net.dv8tion.jda.api.interactions.components.text.TextInput;
import net.dv8tion.jda.api.interactions.modals.Modal;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import net.itsthesky.disky.elements.components.core.ComponentRow;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Message Builder Component Rows")
@Description(value={"Component rows of a message builder", "See also: 'Creator Components Row'"})
public class MessageModalRows
extends MultiplyPropertyExpression<Object, Object> {
    public Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD) {
            return new Class[]{ComponentRow.class, ComponentRow[].class, Button.class, Button[].class, SelectMenu.Builder.class, SelectMenu.Builder[].class, TextInput.Builder.class, TextInput.Builder[].class, Modal.Builder.class, Modal.Builder[].class};
        }
        return new Class[0];
    }

    public void change(@NotNull Event e, @NotNull Object[] delta, @NotNull Changer.ChangeMode mode) {
        if (!EasyElement.isValid(delta)) {
            return;
        }
        Object builder = EasyElement.parseSingle(this.getExpr(), e, null);
        LinkedList<ActionRow> rows = new LinkedList<ActionRow>();
        if (builder == null) {
            return;
        }
        for (Object obj : delta) {
            if (obj instanceof Button) {
                rows.add(ActionRow.of((Button)obj));
                continue;
            }
            if (obj instanceof ComponentRow) {
                rows.add(((ComponentRow)obj).asActionRow());
                continue;
            }
            if (obj instanceof SelectMenu.Builder) {
                rows.add(ActionRow.of(new ItemComponent[]{((SelectMenu.Builder)obj).build()}));
                continue;
            }
            if (!(obj instanceof TextInput.Builder)) continue;
            rows.add(ActionRow.of(((TextInput.Builder)obj).build()));
        }
        if (builder instanceof MessageCreateBuilder) {
            ((MessageCreateBuilder)builder).addComponents(rows);
        } else if (builder instanceof Modal.Builder) {
            ((Modal.Builder)builder).addComponents(rows);
        }
    }

    @Override
    @NotNull
    public Class<?> getReturnType() {
        return Object.class;
    }

    @Override
    protected String getPropertyName() {
        return "rows";
    }

    @Override
    protected Object[] convert(Object object) {
        if (object instanceof MessageCreateBuilder) {
            return ((MessageCreateBuilder)object).getComponents().toArray(new LayoutComponent[0]);
        }
        if (object instanceof Modal.Builder) {
            return ((Modal.Builder)object).getComponents().toArray(new LayoutComponent[0]);
        }
        return new Object[0];
    }

    static {
        MessageModalRows.register(MessageModalRows.class, Object.class, "[component[s]] row[s]", "messagecreatebuilder/modal");
    }
}

