/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.welcome;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.List;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.managers.GuildWelcomeScreenManager;
import net.itsthesky.disky.elements.sections.welcome.ScreenElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Modify Welcome Screen")
@Description(value={"Modify the welcome screen of a guild.", "At the end, the request will be sent to discord to update the welcome screen."})
@Examples(value={"discord command setup <guild>:\n    trigger:\n        modify welcome screen of arg-1:\n            change the screen description to \"Welcome to the server! Please read the rules and get roles before chatting.\"\n            add channel with id \"937001799896956991\" named \"Read our rules\" with reaction \"\ud83d\udcdc\" to the screen\n            add channel with id \"952199041335316520\" named \"Get roles\" with reaction \"\ud83c\udf9f\ufe0f\" to the screen"})
@Since(value={"4.10.0"})
public class ModifySection
extends Section {
    private Expression<Guild> exprGuild;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult, @NotNull SectionNode sectionNode, @NotNull List<TriggerItem> triggerItems) {
        this.exprGuild = exprs[0];
        this.loadCode(sectionNode);
        return true;
    }

    @Nullable
    protected TriggerItem walk(@NotNull Event e) {
        Guild guild = (Guild)this.exprGuild.getSingle(e);
        if (guild == null) {
            return this.getNext();
        }
        ArrayList<ScreenElement> elements = new ArrayList<ScreenElement>();
        this.last.setNext(null);
        for (TriggerItem triggerItem = this.first; triggerItem != null; triggerItem = triggerItem.getNext()) {
            if (!(triggerItem instanceof ScreenElement)) continue;
            elements.add((ScreenElement)triggerItem);
        }
        GuildWelcomeScreenManager manager = guild.modifyWelcomeScreen();
        for (ScreenElement item : elements) {
            manager = item.apply(manager, e);
        }
        manager.queue();
        return this.getNext();
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "modify welcome screen of guild " + this.exprGuild.toString(e, debug);
    }

    static {
        Skript.registerSection(ModifySection.class, (String[])new String[]{"modify [the] welcome screen (of|for) [the] [guild] %guild%"});
    }
}

