/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.events.guild.GuildReadyEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.EventListener;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.Compression;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.events.SimpleDiSkyEvent;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.BotOptions;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.events.rework.BotEvents;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.KeyValueEntryData;
import org.skriptlang.skript.lang.entry.util.LiteralEntryData;
import org.skriptlang.skript.lang.entry.util.VariableStringEntryData;
import org.skriptlang.skript.lang.structure.Structure;

public class StructBot
extends Structure {
    private static final Structure.Priority PRIORITY = new Structure.Priority(500);
    public static final GatewayIntent[] DefaultIntents = new GatewayIntent[]{GatewayIntent.GUILD_MODERATION, GatewayIntent.GUILD_EMOJIS_AND_STICKERS, GatewayIntent.GUILD_WEBHOOKS, GatewayIntent.GUILD_INVITES, GatewayIntent.GUILD_VOICE_STATES, GatewayIntent.GUILD_MESSAGE_REACTIONS, GatewayIntent.GUILD_MESSAGE_TYPING, GatewayIntent.DIRECT_MESSAGES, GatewayIntent.GUILD_MESSAGES, GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_PRESENCES, GatewayIntent.MESSAGE_CONTENT, GatewayIntent.SCHEDULED_EVENTS};
    private String name;
    private EntryContainer container;
    @Nullable
    private BotOptions options;

    public boolean init(Literal<?>[] args2, int matchedPattern, @NotNull SkriptParser.ParseResult parseResult, @NotNull EntryContainer entryContainer) {
        this.name = (String)args2[0].getSingle();
        this.container = entryContainer;
        return true;
    }

    public boolean load() {
        VariableString token = (VariableString)this.container.getOptional("token", VariableString.class, true);
        SectionNode readySection = (SectionNode)this.container.getOptional("on ready", SectionNode.class, true);
        SectionNode guildReadySection = (SectionNode)this.container.getOptional("on guild ready", SectionNode.class, true);
        SectionNode shutdownSection = (SectionNode)this.container.getOptional("on shutdown", SectionNode.class, true);
        if (token == null) {
            Skript.error((String)("The token of the bot '" + this.name + "' is not defined! You need to define it in order to use the bot!"));
            return false;
        }
        Trigger ready = null;
        Trigger guildReady = null;
        Trigger shutdown = null;
        if (readySection != null) {
            ready = new Trigger(this.getParser().getCurrentScript(), "bot '" + this.name + "' ready section", (SkriptEvent)new SimpleEvent(), SkriptUtils.loadCode(readySection, BotEvents.READY_EVENT.getBukkitEventClass()));
        }
        if (guildReadySection != null) {
            guildReady = new Trigger(this.getParser().getCurrentScript(), "bot '" + this.name + "' guild ready section", (SkriptEvent)new SimpleEvent(), SkriptUtils.loadCode(guildReadySection, BotEvents.GUILD_READY_EVENT.getBukkitEventClass()));
        }
        if (shutdownSection != null) {
            shutdown = new Trigger(this.getParser().getCurrentScript(), "bot '" + this.name + "' shutdown section", (SkriptEvent)new SimpleEvent(), SkriptUtils.loadCode(shutdownSection, BotEvents.SHUTDOWN_EVENT.getBukkitEventClass()));
        }
        this.options = new BotOptions();
        this.options.setToken(token.getSingle(new SimpleDiSkyEvent()));
        this.options.setName(this.name);
        this.options.setCompression((Compression)((Object)this.container.getOptional("compression", Compression.class, true)));
        this.options.setFlags((CacheFlag[])this.container.getOptional("cache flags", CacheFlag[].class, true));
        this.options.setPolicy((MemberCachePolicy)this.container.getOptional("policy", MemberCachePolicy.class, true));
        this.options.setAutoReconnect((Boolean)this.container.getOptional("auto reconnect", Boolean.class, true));
        this.options.setForceReload((Boolean)this.container.getOptional("force reload", Boolean.class, true));
        this.options.setOnReady(ready == null ? new ArrayList() : Collections.singletonList(ready));
        this.options.setOnGuildReady(guildReady == null ? new ArrayList() : Collections.singletonList(guildReady));
        this.options.setOnShutdown(shutdown == null ? new ArrayList() : Collections.singletonList(shutdown));
        this.options.setIntents((GatewayIntent[])this.container.getOptional("intents", GatewayIntent[].class, true));
        if (this.options == null) {
            throw new IllegalStateException("The options of the bot '" + this.name + "' are null! This is a bug, please report it on the DiSky GitHub!");
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)DiSky.getInstance(), () -> {
            JDA jda;
            BotOptions parsedEntity = this.options;
            String name = parsedEntity.getName();
            if (DiSky.getManager().exist(name)) {
                Bot bot = DiSky.getManager().fromName(name);
                if (bot.isForceReload()) {
                    bot.getInstance().shutdownNow();
                } else {
                    return;
                }
            }
            try {
                EventListener listener = event -> {
                    if (event instanceof ReadyEvent) {
                        parsedEntity.runReady((ReadyEvent)event);
                    } else if (event instanceof GuildReadyEvent) {
                        parsedEntity.runGuildReady((GuildReadyEvent)event);
                    }
                };
                jda = parsedEntity.toBuilder().addEventListeners(listener).build();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            DiSky.getManager().addBot(parsedEntity.asBot(jda, parsedEntity));
        });
        return true;
    }

    protected MemberCachePolicy parse(String input) {
        try {
            return (MemberCachePolicy)MemberCachePolicy.class.getDeclaredField(input.toUpperCase(Locale.ROOT).replaceAll(" ", "_")).get(null);
        }
        catch (Exception ex) {
            return MemberCachePolicy.DEFAULT;
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "define bot named " + this.name;
    }

    @NotNull
    public Structure.Priority getPriority() {
        return PRIORITY;
    }

    static {
        Skript.registerStructure(StructBot.class, (EntryValidator)EntryValidator.builder().addEntryData((EntryData)new VariableStringEntryData("token", null, false)).addEntryData((EntryData)new KeyValueEntryData<GatewayIntent[]>("intents", DefaultIntents, false){
            private final Pattern pattern = Pattern.compile("\\s*,\\s*/?");

            protected GatewayIntent[] getValue(@NotNull String value) {
                if (value.equalsIgnoreCase("default intents")) {
                    return DefaultIntents;
                }
                return (GatewayIntent[])Arrays.stream(this.pattern.split(value)).map(str -> {
                    try {
                        return GatewayIntent.valueOf(str.toUpperCase().replace(" ", "_"));
                    }
                    catch (Exception ex) {
                        Skript.error((String)("The intent '" + str + "' is not valid! Use one of the following: " + Arrays.toString((Object[])GatewayIntent.values())));
                        return null;
                    }
                }).filter(Objects::nonNull).toArray(GatewayIntent[]::new);
            }
        }).addEntryData((EntryData)new KeyValueEntryData<Compression>("compression", Compression.ZLIB, true){

            protected Compression getValue(@NotNull String value) {
                try {
                    return Compression.valueOf(value.toUpperCase().replace(" ", "_"));
                }
                catch (Exception ex) {
                    Skript.error((String)("The compression type '" + value + "' is not valid! Use one of the following: " + Arrays.toString((Object[])Compression.values())));
                    return Compression.ZLIB;
                }
            }
        }).addEntryData((EntryData)new KeyValueEntryData<CacheFlag[]>("cache flags", new CacheFlag[0], true){
            private final Pattern pattern = Pattern.compile("\\s*,\\s*/?");

            protected CacheFlag[] getValue(@NotNull String value) {
                if (value.equalsIgnoreCase("default flags")) {
                    return new CacheFlag[0];
                }
                return (CacheFlag[])Arrays.stream(this.pattern.split(value)).map(str -> {
                    try {
                        return CacheFlag.valueOf(str.toUpperCase().replace(" ", "_"));
                    }
                    catch (Exception ex) {
                        Skript.error((String)("The cache flag '" + str + "' is not valid! Use one of the following: " + Arrays.toString((Object[])CacheFlag.values())));
                        return null;
                    }
                }).filter(Objects::nonNull).toArray(CacheFlag[]::new);
            }
        }).addEntryData((EntryData)new KeyValueEntryData<MemberCachePolicy>("policy", MemberCachePolicy.DEFAULT, true){

            protected MemberCachePolicy getValue(@NotNull String value) {
                try {
                    return (MemberCachePolicy)MemberCachePolicy.class.getDeclaredField(value.toUpperCase(Locale.ROOT).replaceAll(" ", "_")).get(null);
                }
                catch (Exception ex) {
                    Skript.error((String)("The member cache policy '" + value + "' is not valid!"));
                    return MemberCachePolicy.DEFAULT;
                }
            }
        }).addEntryData((EntryData)new LiteralEntryData("auto reconnect", (Object)true, true, Boolean.class)).addEntryData((EntryData)new LiteralEntryData("force reload", (Object)false, true, Boolean.class)).addSection("on ready", true).addSection("on guild ready", true).addSection("on shutdown", true).unexpectedEntryMessage(key -> "Unexpected entry '" + key + "'. Check that it's spelled correctly, and ensure that you have put all code into a trigger.").build(), (String[])new String[]{"define [the] [new] bot (with name|named) %string%"});
    }
}

