/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.guild.GuildReadyEvent;
import net.dv8tion.jda.api.events.interaction.command.MessageContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.UserContextInteractionEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import net.itsthesky.disky.elements.structures.context.ParsedContextCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContextCommandManager
extends ListenerAdapter {
    private static final Map<Bot, ContextCommandManager> MANAGERS = new HashMap<Bot, ContextCommandManager>();
    private final Map<String, List<Runnable>> waitingGuildCommands = new HashMap<String, List<Runnable>>();
    private final Set<String> readyGuilds = new HashSet<String>();
    private final List<Runnable> waitingGlobalCommands = new ArrayList<Runnable>();
    private final Map<Long, ParsedContextCommand> registeredCommands = new ConcurrentHashMap<Long, ParsedContextCommand>();
    private final Bot bot;
    private boolean readyGlobal = false;

    public static ContextCommandManager getManager(Bot bot) {
        return MANAGERS.computeIfAbsent(bot, ContextCommandManager::new);
    }

    public static void shutdownAll() {
        MANAGERS.values().forEach(ContextCommandManager::shutdown);
        MANAGERS.clear();
    }

    private ContextCommandManager(Bot bot) {
        this.bot = bot;
        DiSky.debug("Created ContextCommandManager for bot " + bot.getName());
        this.bot.getInstance().addEventListener(this);
    }

    public void registerCommand(ParsedContextCommand command) {
        CommandData commandData = command.getType() == Command.Type.USER ? Commands.user(command.getName()) : Commands.message(command.getName());
        if (command.getNameLocalizations() != null && !command.getNameLocalizations().isEmpty()) {
            commandData.setNameLocalizations(command.getNameLocalizations());
        }
        commandData.setDefaultPermissions(command.getPermissions());
        if (command.getGuilds().isEmpty()) {
            this.registerGlobalCommand(command, commandData);
        } else {
            for (String guildId : command.getGuilds()) {
                this.registerGuildCommand(command, commandData, guildId);
            }
        }
    }

    private void registerGlobalCommand(ParsedContextCommand command, CommandData commandData) {
        Runnable registrationTask = () -> this.bot.getInstance().upsertCommand(commandData).queue(cmd -> {
            this.registeredCommands.put(cmd.getIdLong(), command);
            DiSky.debug("Successfully registered command " + command.getName() + " globally");
        }, error -> DiSky.debug("Failed to register command " + command.getName() + ": " + error.getMessage()));
        if (this.readyGlobal) {
            registrationTask.run();
        } else {
            this.waitingGlobalCommands.add(registrationTask);
        }
    }

    private void registerGuildCommand(ParsedContextCommand command, CommandData commandData, String guildId) {
        Runnable registrationTask = () -> {
            Guild guild = this.bot.getInstance().getGuildById(guildId);
            if (guild == null) {
                DiSky.debug("Guild " + guildId + " not found for command " + command.getName());
                return;
            }
            guild.upsertCommand(commandData).queue(cmd -> {
                this.registeredCommands.put(cmd.getIdLong(), command);
                DiSky.debug("Successfully registered command " + command.getName() + " in guild " + guildId);
            }, error -> DiSky.debug("Failed to register command " + command.getName() + " in guild " + guildId + ": " + error.getMessage()));
        };
        if (this.readyGuilds.contains(guildId)) {
            registrationTask.run();
        } else {
            this.waitingGuildCommands.computeIfAbsent(guildId, k -> new ArrayList()).add(registrationTask);
        }
    }

    @Override
    public void onUserContextInteraction(@NotNull UserContextInteractionEvent event) {
        this.handleContextCommand(event.getCommandIdLong(), event);
    }

    @Override
    public void onMessageContextInteraction(@NotNull MessageContextInteractionEvent event) {
        this.handleContextCommand(event.getCommandIdLong(), event);
    }

    private void handleContextCommand(long commandId, Object event) {
        ParsedContextCommand command = this.registeredCommands.get(commandId);
        if (command == null) {
            DiSky.debug("Received unregistered context command with ID: " + commandId);
            return;
        }
        try {
            command.getTrigger().execute(command.wrapEvent(event));
        }
        catch (Exception e) {
            DiSkyRuntimeHandler.error(new Exception("Failed to execute context command " + command.getName(), e));
        }
    }

    @Override
    public void onReady(@NotNull ReadyEvent event) {
        this.readyGlobal = true;
        DiSky.debug("Bot " + this.bot.getName() + " ready, registering global commands (" + this.waitingGlobalCommands.size() + ")");
        this.waitingGlobalCommands.forEach(Runnable::run);
        this.waitingGlobalCommands.clear();
    }

    @Override
    public void onGuildReady(@NotNull GuildReadyEvent event) {
        String guildId = event.getGuild().getId();
        if (!this.waitingGuildCommands.containsKey(guildId)) {
            return;
        }
        this.readyGuilds.add(guildId);
        List<Runnable> tasks = this.waitingGuildCommands.remove(guildId);
        DiSky.debug("Guild " + guildId + " ready, registering commands (" + tasks.size() + ")");
        tasks.forEach(Runnable::run);
    }

    public void shutdown() {
        this.bot.getInstance().removeEventListener(this);
        this.cleanupCommands();
        this.registeredCommands.clear();
    }

    private void cleanupCommands() {
        ArrayList actions = new ArrayList();
        this.registeredCommands.forEach((id, command) -> {
            if (command.getGuilds().isEmpty()) {
                actions.add(this.bot.getInstance().deleteCommandById((long)id));
            }
        });
        this.registeredCommands.forEach((id, command) -> {
            for (String guildId : command.getGuilds()) {
                Guild guild = this.bot.getInstance().getGuildById(guildId);
                if (guild == null) continue;
                actions.add(guild.deleteCommandById((long)id));
            }
        });
        try {
            RestAction.allOf(actions).complete();
        }
        catch (Exception e) {
            DiSkyRuntimeHandler.error(new Exception("Failed to delete commands", e));
        }
    }

    @Nullable
    public ParsedContextCommand getCommand(long id) {
        return this.registeredCommands.get(id);
    }

    public Collection<ParsedContextCommand> getRegisteredCommands() {
        return Collections.unmodifiableCollection(this.registeredCommands.values());
    }
}

