/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.context;

import ch.njol.skript.lang.Trigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dv8tion.jda.api.events.interaction.command.MessageContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.UserContextInteractionEvent;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.itsthesky.disky.elements.events.rework.CommandEvents;
import org.bukkit.event.Event;

public class ParsedContextCommand {
    private final Command.Type type;
    private String name;
    private Map<DiscordLocale, String> nameLocalizations;
    private List<String> guilds;
    private String rawBot;
    private DefaultMemberPermissions permissions;
    private Trigger trigger;

    public ParsedContextCommand(Command.Type type) {
        this.type = type;
        this.nameLocalizations = new HashMap<DiscordLocale, String>();
        this.guilds = new ArrayList<String>();
    }

    public Event wrapEvent(Object event) {
        if (event instanceof UserContextInteractionEvent) {
            UserContextInteractionEvent jdaEvent = (UserContextInteractionEvent)event;
            return CommandEvents.USER_COMMAND_EVENT.createBukkitInstance(jdaEvent);
        }
        if (event instanceof MessageContextInteractionEvent) {
            MessageContextInteractionEvent jdaEvent = (MessageContextInteractionEvent)event;
            return CommandEvents.MESSAGE_COMMAND_EVENT.createBukkitInstance(jdaEvent);
        }
        throw new IllegalArgumentException("Unknown event type: " + event.getClass().getName());
    }

    public Command.Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<DiscordLocale, String> getNameLocalizations() {
        return this.nameLocalizations;
    }

    public void setNameLocalizations(Map<DiscordLocale, String> nameLocalizations) {
        this.nameLocalizations = nameLocalizations;
    }

    public List<String> getGuilds() {
        return this.guilds;
    }

    public void addGuild(String guildId) {
        this.guilds.add(guildId);
    }

    public String getRawBot() {
        return this.rawBot;
    }

    public void setRawBot(String rawBot) {
        this.rawBot = rawBot;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public DefaultMemberPermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(DefaultMemberPermissions permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParsedContextCommand that = (ParsedContextCommand)o;
        return this.type == that.type && Objects.equals(this.name, that.name) && Objects.equals(this.guilds, that.guilds) && Objects.equals(this.rawBot, that.rawBot);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.guilds, this.rawBot});
    }

    public String toString() {
        return "ParsedContextCommand{type=" + String.valueOf((Object)this.type) + ", name='" + this.name + "', guilds=" + String.valueOf(this.guilds) + ", bot='" + this.rawBot + "'}";
    }
}

