/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.context;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.Trigger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.events.interaction.command.GenericContextInteractionEvent;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.events.rework.BuiltEvent;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.events.rework.CommandEvents;
import net.itsthesky.disky.elements.structures.context.ParsedContextCommand;
import net.itsthesky.disky.elements.structures.slash.BotReadyWaiter;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.structure.Structure;

public class StructContextCommand
extends Structure {
    public static final Structure.Priority PRIORITY = new Structure.Priority(800);
    private static final Pattern LIST = Pattern.compile("\\s*,\\s*/?");
    private static final EntryValidator VALIDATOR = EntryValidator.builder().addEntry("bot", "", false).addSection("trigger", false).addEntry("guilds", "", true).addEntry("enabled for", "all", true).addSection("name", true).build();
    private ParsedContextCommand parsedCommand;
    private EntryContainer entryContainer;
    private Node structure;

    public boolean init(Literal<?> @NotNull [] args2, int matchedPattern, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult, @NotNull EntryContainer entryContainer) {
        String name;
        this.entryContainer = entryContainer;
        this.structure = entryContainer.getSource();
        Command.Type type = matchedPattern == 0 ? Command.Type.USER : Command.Type.MESSAGE;
        this.parsedCommand = new ParsedContextCommand(type);
        String string = name = args2[0] == null ? null : (String)args2[0].getSingle();
        if (name == null) {
            Skript.error((String)"Command name cannot be null");
            return false;
        }
        this.parsedCommand.setName(name);
        return true;
    }

    public boolean load() {
        if (!this.parseName()) {
            return false;
        }
        if (!this.parsePlaces()) {
            return false;
        }
        if (!this.parseTrigger()) {
            return false;
        }
        if (!this.parsePermissions()) {
            return false;
        }
        DiSky.debug("------------------- Name -------------------");
        DiSky.debug("Default: " + this.parsedCommand.getName());
        for (DiscordLocale locale : this.parsedCommand.getNameLocalizations().keySet()) {
            DiSky.debug(" - Locale: " + String.valueOf((Object)locale) + " | Value: " + this.parsedCommand.getNameLocalizations().get((Object)locale));
        }
        if (this.parsedCommand.getNameLocalizations().isEmpty()) {
            DiSky.debug("No localizations found.");
        }
        DiSky.debug("------------------- Places -------------------");
        DiSky.debug("Pre-bot (name): " + this.parsedCommand.getRawBot());
        for (String guild : this.parsedCommand.getGuilds()) {
            DiSky.debug("- Guild: " + guild);
        }
        DiSky.debug("------------------- Trigger -------------------");
        if (this.parsedCommand.getTrigger() != null) {
            DiSky.debug("Trigger found.");
            DiSky.debug(" - Label: " + this.parsedCommand.getTrigger().getDebugLabel());
        } else {
            DiSky.debug("No trigger found.");
        }
        DiSky.debug("------------------- Permissions -------------------");
        DiSky.debug("Enabled for: " + String.valueOf(this.parsedCommand.getPermissions().getPermissionsRaw() == null ? "all" : Permission.getPermissions(this.parsedCommand.getPermissions().getPermissionsRaw())));
        Bot bot = DiSky.getManager().getBotByName(this.parsedCommand.getRawBot());
        if (bot != null && bot.getInstance().getStatus() == JDA.Status.CONNECTED) {
            bot.getContextManager().registerCommand(this.parsedCommand);
        } else {
            BotReadyWaiter.WaitingContextCommands.computeIfAbsent(this.parsedCommand.getRawBot(), k -> new ArrayList()).add(this.parsedCommand);
        }
        return true;
    }

    private boolean parseName() {
        SectionNode sectionNode = (SectionNode)this.entryContainer.getOptional("name", SectionNode.class, true);
        if (sectionNode == null) {
            return true;
        }
        sectionNode.convertToEntries(0);
        HashMap<DiscordLocale, String> localizations = new HashMap<DiscordLocale, String>();
        for (Node node : sectionNode) {
            String key = node.getKey();
            String value = sectionNode.get(key, "");
            if (value.isEmpty()) {
                Skript.error((String)("Empty localization value for key: " + key));
                return false;
            }
            DiscordLocale locale = DiscordLocale.from(key.equals("en") ? "en-US" : key);
            if (locale == DiscordLocale.UNKNOWN) {
                Skript.error((String)("Invalid locale key: " + key + " (Available: " + Arrays.toString((Object[])DiscordLocale.values()) + ")"));
                return false;
            }
            localizations.put(locale, value);
        }
        this.parsedCommand.setNameLocalizations(localizations);
        return true;
    }

    private boolean parsePlaces() {
        String rawBot = (String)this.entryContainer.getOptional("bot", String.class, true);
        String rawGuilds = (String)this.entryContainer.getOptional("guilds", String.class, true);
        if (rawBot == null || rawBot.isEmpty()) {
            Skript.error((String)"You must specify a bot for the command.");
            return false;
        }
        this.parsedCommand.setRawBot(rawBot);
        if (rawGuilds != null && !rawGuilds.isEmpty()) {
            String[] guildIds;
            for (String guildId : guildIds = rawGuilds.split(LIST.pattern())) {
                if (!guildId.matches("\\d+")) {
                    Skript.error((String)("Invalid guild ID: " + guildId));
                    return false;
                }
                this.parsedCommand.addGuild(guildId);
            }
        }
        return true;
    }

    private boolean parseTrigger() {
        SectionNode sectionNode = (SectionNode)this.entryContainer.getOptional("trigger", SectionNode.class, true);
        if (sectionNode == null) {
            Skript.error((String)"You must specify a trigger section for the command.");
            return false;
        }
        BuiltEvent<GenericContextInteractionEvent> builtEvent = this.parsedCommand.getType() == Command.Type.USER ? CommandEvents.USER_COMMAND_EVENT : CommandEvents.MESSAGE_COMMAND_EVENT;
        Class<Event> eventClass = builtEvent.getBukkitEventClass();
        Trigger trigger = new Trigger(this.getParser().getCurrentScript(), "on " + this.parsedCommand.getType().name().toLowerCase() + " command " + this.parsedCommand.getName(), builtEvent.createDiSkyEvent(), SkriptUtils.loadCode(sectionNode, eventClass));
        this.parsedCommand.setTrigger(trigger);
        return true;
    }

    private boolean parsePermissions() {
        String rawPermissions = (String)this.entryContainer.getOptional("enabled for", String.class, true);
        if (rawPermissions == null) {
            Skript.error((String)"You must specify the permissions for the command.");
            return false;
        }
        DefaultMemberPermissions permissions = rawPermissions.equalsIgnoreCase("all") || rawPermissions.equalsIgnoreCase("enabled") ? DefaultMemberPermissions.ENABLED : (rawPermissions.equalsIgnoreCase("none") || rawPermissions.equalsIgnoreCase("disabled") ? DefaultMemberPermissions.DISABLED : DefaultMemberPermissions.enabledFor((Permission[])Arrays.stream(LIST.split(rawPermissions)).map(raw -> Permission.valueOf(raw.toUpperCase().replace(" ", "_"))).toArray(Permission[]::new)));
        this.parsedCommand.setPermissions(permissions);
        return true;
    }

    @NotNull
    public Structure.Priority getPriority() {
        return PRIORITY;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "Context Command Structure";
    }

    static {
        Skript.registerStructure(StructContextCommand.class, (EntryValidator)VALIDATOR, (String[])new String[]{"user command %string%", "message command %string%"});
    }
}

