/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.structures.context.ContextCommandManager;
import net.itsthesky.disky.elements.structures.context.ParsedContextCommand;
import net.itsthesky.disky.elements.structures.slash.SlashManager;
import net.itsthesky.disky.elements.structures.slash.models.ParsedCommand;

public final class BotReadyWaiter {
    public static final Map<String, List<ParsedCommand>> WaitingCommands = new HashMap<String, List<ParsedCommand>>();
    public static final Map<String, List<ParsedContextCommand>> WaitingContextCommands = new HashMap<String, List<ParsedContextCommand>>();

    public static void onBotLoaded(Bot bot) {
        BotReadyWaiter.checkCommands(bot);
        BotReadyWaiter.checkContextCommands(bot);
    }

    private static void checkCommands(Bot bot) {
        List<ParsedCommand> commands = WaitingCommands.get(bot.getName());
        if (commands == null || commands.isEmpty()) {
            return;
        }
        SlashManager slashManager = bot.getSlashManager();
        commands.forEach(slashManager::registerCommand);
        WaitingCommands.remove(bot.getName());
    }

    private static void checkContextCommands(Bot bot) {
        List<ParsedContextCommand> commands = WaitingContextCommands.get(bot.getName());
        if (commands == null || commands.isEmpty()) {
            return;
        }
        ContextCommandManager contextManager = bot.getContextManager();
        commands.forEach(contextManager::registerCommand);
        WaitingContextCommands.remove(bot.getName());
    }
}

