/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash.args.custom;

import ch.njol.skript.util.Color;
import ch.njol.skript.util.ColorRGB;
import ch.njol.skript.util.SkriptColor;
import java.util.ArrayList;
import java.util.List;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.itsthesky.disky.elements.structures.slash.args.CustomArgument;
import net.itsthesky.disky.elements.structures.slash.args.custom.SmallEnumCustomArg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorCustomArg
extends CustomArgument<Color> {
    public ColorCustomArg() {
        super(Color.class, OptionType.STRING, true, false);
    }

    @Override
    @Nullable
    public Color convert(@NotNull SlashCommandInteractionEvent event, @NotNull OptionMapping mapping) {
        String colorString = mapping.getAsString();
        try {
            return ColorCustomArg.colorFromHex(colorString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public Color convert(@NotNull CommandAutoCompleteInteractionEvent event, @NotNull OptionMapping mapping) {
        String colorString = mapping.getAsString();
        try {
            return ColorCustomArg.colorFromHex(colorString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public List<Command.Choice> handleAutoCompletion(@NotNull CommandAutoCompleteInteractionEvent event, @NotNull String input) {
        if (input.startsWith("#")) {
            Color clr;
            String color = input.substring(1);
            if ((color.length() == 6 || color.length() == 8) && (clr = ColorCustomArg.colorFromHex(color)) != null) {
                return List.of(new Command.Choice("Color: #" + color, "#" + color));
            }
            return List.of(new Command.Choice("Invalid hex color. Format: #RRGGBB or #RRGGBBAA", "#FF0000"));
        }
        if (input.startsWith("rgb")) {
            block13: {
                try {
                    int firstParenthesis = input.indexOf(40);
                    String color = input.substring(firstParenthesis + 1, input.length() - 1).replace(" ", "");
                    String[] parts = color.split(",");
                    if (parts.length == 3) {
                        try {
                            int r = Integer.parseInt(parts[0]);
                            int g = Integer.parseInt(parts[1]);
                            int b = Integer.parseInt(parts[2]);
                            if (r >= 0 && r <= 255 && g >= 0 && g <= 255 && b >= 0 && b <= 255) {
                                return List.of(new Command.Choice("rgb(" + r + ", " + g + ", " + b + ")", ColorCustomArg.rbgToHex(r, g, b)));
                            }
                            break block13;
                        }
                        catch (NumberFormatException r) {}
                        break block13;
                    }
                    if (parts.length != 4) break block13;
                    try {
                        int r = Integer.parseInt(parts[0]);
                        int g = Integer.parseInt(parts[1]);
                        int b = Integer.parseInt(parts[2]);
                        int a = Integer.parseInt(parts[3]);
                        if (r >= 0 && r <= 255 && g >= 0 && g <= 255 && b >= 0 && b <= 255 && a >= 0 && a <= 255) {
                            return List.of(new Command.Choice("rgb(" + r + ", " + g + ", " + b + ", " + a + ")", ColorCustomArg.rbgToHex(r, g, b)));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                catch (StringIndexOutOfBoundsException firstParenthesis) {
                    // empty catch block
                }
            }
            return List.of(new Command.Choice("Invalid rgb color. Format: rgb(R, G, B)", "#FF0000"));
        }
        ArrayList<Command.Choice> matchingColors = new ArrayList<Command.Choice>();
        for (SkriptColor color : SkriptColor.values()) {
            if (!color.getName().toLowerCase().startsWith(input.toLowerCase())) continue;
            matchingColors.add(new Command.Choice(SmallEnumCustomArg.beautifyEnumName(color.getName()), ColorCustomArg.colorToHex((Color)color)));
        }
        return matchingColors;
    }

    private static String rbgToHex(int r, int g, int b) {
        return "#" + String.format("%02X%02X%02X", r, g, b);
    }

    private static String colorToHex(Color color) {
        return ColorCustomArg.rbgToHex(color.getRed(), color.getGreen(), color.getBlue());
    }

    private static Color colorFromHex(String hex) {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4, 6), 16);
        if (hex.length() == 8) {
            int a = Integer.parseInt(hex.substring(6, 8), 16);
            return ColorRGB.fromRGBA((int)r, (int)g, (int)b, (int)a);
        }
        return ColorRGB.fromRGB((int)r, (int)g, (int)b);
    }
}

