/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash.args.custom;

import ch.njol.skript.classes.ClassInfo;
import java.util.List;
import java.util.stream.Stream;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.itsthesky.disky.elements.structures.slash.args.CustomArgument;
import net.itsthesky.disky.elements.structures.slash.args.custom.SmallEnumCustomArg;
import org.jetbrains.annotations.NotNull;

public class EnumCustomArg
extends CustomArgument<Enum> {
    public EnumCustomArg(Class<Enum> clazz) {
        super(clazz, OptionType.STRING, true, false);
    }

    @Override
    public Enum convert(SlashCommandInteractionEvent event, OptionMapping mapping) {
        String enumName = mapping.getAsString();
        return Enum.valueOf(this.clazz, enumName);
    }

    @Override
    public Enum convert(CommandAutoCompleteInteractionEvent event, OptionMapping mapping) {
        String enumName = mapping.getAsString();
        return Enum.valueOf(this.clazz, enumName);
    }

    @Override
    public List<Command.Choice> handleAutoCompletion(@NotNull CommandAutoCompleteInteractionEvent event, @NotNull String input) {
        Enum[] enumConstants = (Enum[])this.clazz.getEnumConstants();
        return Stream.of(enumConstants).filter(enumConstant -> SmallEnumCustomArg.beautifyEnumName(enumConstant.name()).toLowerCase().startsWith(input.toLowerCase())).map(enumConstant -> new Command.Choice(SmallEnumCustomArg.beautifyEnumName(enumConstant.name()), enumConstant.name())).limit(25L).toList();
    }

    @Override
    public boolean supportsClass(@NotNull ClassInfo<?> classInfo) {
        return classInfo.getC().isEnum() && classInfo.getC().isAssignableFrom(this.clazz);
    }
}

