/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash.args.custom;

import ch.njol.skript.classes.ClassInfo;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.itsthesky.disky.elements.structures.slash.args.CustomArgument;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerCustomArg
extends CustomArgument<OfflinePlayer> {
    private final boolean offline;

    public PlayerCustomArg(boolean offline) {
        super(OfflinePlayer.class, OptionType.STRING, true, false);
        this.offline = offline;
    }

    @Override
    public boolean supportsClass(@NotNull ClassInfo<?> classInfo) {
        if (this.offline) {
            return OfflinePlayer.class.isAssignableFrom(classInfo.getC());
        }
        return Player.class.isAssignableFrom(classInfo.getC());
    }

    @Override
    public List<Command.Choice> handleAutoCompletion(@NotNull CommandAutoCompleteInteractionEvent event, @NotNull String input) {
        List<OfflinePlayer> players = this.offline ? List.of(Bukkit.getOfflinePlayers()) : Arrays.asList(Bukkit.getOnlinePlayers().toArray(new OfflinePlayer[0]));
        return players.stream().filter(player -> player.getName() != null).filter(player -> player.getName().toLowerCase().startsWith(input.toLowerCase())).map(player -> new Command.Choice(player.getName(), player.getUniqueId().toString())).toList();
    }

    @Override
    @Nullable
    public OfflinePlayer convert(@NotNull SlashCommandInteractionEvent event, @NotNull OptionMapping mapping) {
        String playerName = mapping.getAsString();
        UUID uuid = UUID.fromString(playerName);
        return this.offline ? Bukkit.getOfflinePlayer((UUID)uuid) : Bukkit.getPlayer((UUID)uuid);
    }

    @Override
    @Nullable
    public OfflinePlayer convert(@NotNull CommandAutoCompleteInteractionEvent event, @NotNull OptionMapping mapping) {
        String playerName = mapping.getAsString();
        UUID uuid = UUID.fromString(playerName);
        return this.offline ? Bukkit.getOfflinePlayer((UUID)uuid) : Bukkit.getPlayer((UUID)uuid);
    }
}

