/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.elements.structures.slash.models.CommandType;
import net.itsthesky.disky.elements.structures.slash.models.ParsedArgument;
import net.itsthesky.disky.elements.structures.slash.models.ParsedCommand;

public class CommandGroup {
    private final String name;
    private final CommandType type;
    private final Map<String, ParsedCommand> subCommands;
    private final Map<String, CommandGroup> subGroups;
    private ParsedCommand singleCommand;
    private String description;
    private Map<DiscordLocale, String> descriptionLocalizations;
    private Map<DiscordLocale, String> nameLocalizations;

    public CommandGroup(String name, CommandType type) {
        this.name = name;
        this.type = type;
        this.subCommands = new HashMap<String, ParsedCommand>();
        this.subGroups = new HashMap<String, CommandGroup>();
        this.descriptionLocalizations = new HashMap<DiscordLocale, String>();
        this.nameLocalizations = new HashMap<DiscordLocale, String>();
        this.description = "Commands for " + name;
    }

    public void setSingleCommand(ParsedCommand command) {
        if (this.type != CommandType.SINGLE) {
            throw new IllegalStateException("Cannot set single command on a " + String.valueOf((Object)this.type) + " group");
        }
        this.singleCommand = command;
        this.description = command.getDescription();
        this.descriptionLocalizations = command.getDescriptionLocalizations();
        this.nameLocalizations = command.getNameLocalizations();
    }

    public void addSubCommand(ParsedCommand command) {
        String[] parts = command.getName().split(" ");
        String originalName = command.getName();
        if (parts.length == 1) {
            this.setSingleCommand(command);
            return;
        }
        if (!Objects.equals(parts[0], this.name)) {
            throw new IllegalArgumentException("Command name must start with the group name: " + command.getName());
        }
        if (parts.length == 2) {
            String subCommandName = parts[1];
            ParsedCommand subCommand = this.cloneCommandWithNewName(command, subCommandName);
            subCommand.setOriginalName(originalName);
            this.subCommands.put(subCommandName, subCommand);
        } else if (parts.length == 3) {
            String groupName = parts[1];
            String subCommandName = parts[2];
            CommandGroup subGroup = this.subGroups.computeIfAbsent(groupName, name -> {
                CommandGroup group = new CommandGroup((String)name, CommandType.GROUP);
                group.setDescription("Commands for " + name);
                return group;
            });
            ParsedCommand subCommand = this.cloneCommandWithNewName(command, subCommandName);
            subCommand.setOriginalName(originalName);
            subGroup.getSubCommands().put(subCommandName, subCommand);
        } else {
            DiSky.debug("Command name has too many parts (max 3 levels): " + command.getName());
        }
    }

    private ParsedCommand cloneCommandWithNewName(ParsedCommand original, String newName) {
        ParsedCommand clone = new ParsedCommand();
        clone.setName(newName);
        clone.setDescription(original.getDescription());
        clone.setDescriptionLocalizations(new HashMap<DiscordLocale, String>(original.getDescriptionLocalizations()));
        clone.setNameLocalizations(new HashMap<DiscordLocale, String>(original.getNameLocalizations()));
        clone.setArguments(new ArrayList<ParsedArgument>(original.getArguments()));
        clone.setEnabledFor(new ArrayList<Permission>(original.getEnabledFor()));
        clone.setDisabledByDefault(original.isDisabledByDefault());
        clone.setRawBot(original.getRawBot());
        clone.setTrigger(original.getTrigger());
        clone.setCooldown(original.getCooldown());
        clone.setOnCooldown(original.getOnCooldown());
        return clone;
    }

    public SlashCommandData buildCommandData() {
        SlashCommandData commandData = Commands.slash(this.name, this.getDescription());
        if (!this.nameLocalizations.isEmpty()) {
            commandData.setNameLocalizations((Map)this.nameLocalizations);
        }
        if (!this.descriptionLocalizations.isEmpty()) {
            commandData.setDescriptionLocalizations(this.descriptionLocalizations);
        }
        if (this.type == CommandType.SINGLE) {
            if (this.singleCommand != null) {
                for (ParsedArgument parsedArgument : this.singleCommand.getArguments()) {
                    commandData.addOptions(this.createOptionData(parsedArgument));
                }
                if (this.singleCommand.isDisabledByDefault() && this.singleCommand.getEnabledFor().isEmpty()) {
                    commandData.setDefaultPermissions(DefaultMemberPermissions.DISABLED);
                } else if (!this.singleCommand.getEnabledFor().isEmpty()) {
                    commandData.setDefaultPermissions(DefaultMemberPermissions.enabledFor(this.singleCommand.getEnabledFor()));
                }
            }
            return commandData;
        }
        for (ParsedCommand parsedCommand : this.subCommands.values()) {
            SubcommandData subCommandData = this.createSubcommandData(parsedCommand);
            commandData.addSubcommands(subCommandData);
        }
        for (Map.Entry entry : this.subGroups.entrySet()) {
            CommandGroup subGroup = (CommandGroup)entry.getValue();
            SubcommandGroupData groupData = new SubcommandGroupData((String)entry.getKey(), subGroup.getDescription());
            for (ParsedCommand groupCommand : subGroup.getSubCommands().values()) {
                SubcommandData subCommandData = this.createSubcommandData(groupCommand);
                groupData.addSubcommands(subCommandData);
            }
            commandData.addSubcommandGroups(groupData);
        }
        return commandData;
    }

    private OptionData createOptionData(ParsedArgument arg) {
        OptionData optionData = new OptionData(arg.getType(), arg.getName(), arg.getDescription(), arg.isRequired());
        if (arg.hasChoices()) {
            for (Map.Entry<String, Object> choice : arg.getChoices().entrySet()) {
                if (choice.getValue() instanceof String) {
                    optionData.addChoice(choice.getKey(), (String)choice.getValue());
                    continue;
                }
                if (!(choice.getValue() instanceof Number)) continue;
                if (arg.getType() == OptionType.INTEGER) {
                    optionData.addChoice(choice.getKey(), ((Number)choice.getValue()).longValue());
                    continue;
                }
                optionData.addChoice(choice.getKey(), ((Number)choice.getValue()).doubleValue());
            }
        }
        if (arg.getCustomArgument() != null && arg.getCustomArgument().isChoices()) {
            optionData.addChoices(arg.getCustomArgument().getChoices());
        }
        if (arg.isAutoCompletion()) {
            optionData.setAutoComplete(true);
        }
        return optionData;
    }

    private SubcommandData createSubcommandData(ParsedCommand command) {
        SubcommandData subCommandData = new SubcommandData(command.getName(), command.getDescription() != null ? command.getDescription() : "No description provided");
        for (ParsedArgument arg : command.getArguments()) {
            subCommandData.addOptions(this.createOptionData(arg));
        }
        return subCommandData;
    }

    public ParsedCommand findCommand(String fullCommandPath) {
        String[] parts = fullCommandPath.split(" ");
        if (parts.length == 0 || !parts[0].equals(this.name)) {
            return null;
        }
        if (parts.length == 1) {
            if (this.type == CommandType.SINGLE) {
                return this.singleCommand;
            }
            return null;
        }
        if (parts.length == 2) {
            return this.subCommands.get(parts[1]);
        }
        if (parts.length == 3) {
            CommandGroup subGroup = this.subGroups.get(parts[1]);
            if (subGroup == null) {
                return null;
            }
            return subGroup.getSubCommands().get(parts[2]);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public CommandType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description != null ? this.description : "Commands for " + this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<DiscordLocale, String> getDescriptionLocalizations() {
        return this.descriptionLocalizations;
    }

    public void setDescriptionLocalizations(Map<DiscordLocale, String> descriptionLocalizations) {
        this.descriptionLocalizations = descriptionLocalizations;
    }

    public Map<DiscordLocale, String> getNameLocalizations() {
        return this.nameLocalizations;
    }

    public void setNameLocalizations(Map<DiscordLocale, String> nameLocalizations) {
        this.nameLocalizations = nameLocalizations;
    }

    public Map<String, ParsedCommand> getSubCommands() {
        return this.subCommands;
    }

    public Map<String, CommandGroup> getSubGroups() {
        return this.subGroups;
    }

    public ParsedCommand getSingleCommand() {
        return this.singleCommand;
    }

    public String toString() {
        return "CommandGroup{name='" + this.name + "', type=" + String.valueOf((Object)this.type) + ", subCommandsCount=" + this.subCommands.size() + ", subGroupsCount=" + this.subGroups.size() + ", hasSingleCommand=" + (this.singleCommand != null) + "}";
    }
}

