/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash.models;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.registrations.Classes;
import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Map;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.itsthesky.disky.elements.structures.slash.args.CustomArgument;
import org.jetbrains.annotations.Nullable;

public class ParsedArgument {
    private final OptionType type;
    private final String name;
    private final boolean required;
    private String description;
    private Map<String, Object> choices;
    @Nullable
    private Trigger onCompletionRequest;
    private Object value;
    @Nullable
    private CustomArgument<?> customArgument;

    public ParsedArgument(OptionType type, String name, boolean required) {
        this.type = type;
        this.name = name;
        this.required = required;
        this.choices = new HashMap<String, Object>();
        this.description = "No description provided.";
        this.onCompletionRequest = null;
    }

    public OptionType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addChoice(String name, Object arg) {
        this.choices.put(name, arg);
    }

    public Map<String, Object> getChoices() {
        return this.choices;
    }

    public void setOnCompletionRequest(@Nullable Trigger onCompletionRequest) {
        this.onCompletionRequest = onCompletionRequest;
    }

    @Nullable
    public Trigger getOnCompletionRequest() {
        return this.onCompletionRequest;
    }

    public boolean hasChoices() {
        return !this.choices.isEmpty();
    }

    public boolean isOptional() {
        return !this.required;
    }

    public boolean isAutoCompletion() {
        return this.onCompletionRequest != null || this.customArgument != null && this.customArgument.isAutoCompletion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParsedArgument that = (ParsedArgument)o;
        return this.required == that.required && this.type == that.type && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal(this.choices, that.choices);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.name, this.required, this.description, this.choices});
    }

    public ClassInfo<?> getTypeInfo() {
        if (this.customArgument != null) {
            return Classes.getExactClassInfo(this.customArgument.getClazz());
        }
        return switch (this.type) {
            case OptionType.STRING -> Classes.getExactClassInfo(String.class);
            case OptionType.INTEGER -> Classes.getExactClassInfo(Integer.class);
            case OptionType.BOOLEAN -> Classes.getExactClassInfo(Boolean.class);
            case OptionType.USER -> Classes.getExactClassInfo(User.class);
            case OptionType.CHANNEL -> Classes.getExactClassInfo(MessageChannel.class);
            case OptionType.ROLE -> Classes.getExactClassInfo(Role.class);
            case OptionType.NUMBER -> Classes.getExactClassInfo(Number.class);
            case OptionType.ATTACHMENT -> Classes.getExactClassInfo(Message.Attachment.class);
            case OptionType.MENTIONABLE -> Classes.getExactClassInfo(IMentionable.class);
            default -> Classes.getExactClassInfo(Object.class);
        };
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Nullable
    public CustomArgument<?> getCustomArgument() {
        return this.customArgument;
    }

    public void setCustomArgument(@Nullable CustomArgument<?> customArgument) {
        this.customArgument = customArgument;
    }

    public boolean isCustomArgument() {
        return this.customArgument != null;
    }
}

