/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash.models;

import ch.njol.skript.lang.Trigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.JDAUtils;
import net.itsthesky.disky.elements.structures.slash.args.CustomArgument;
import net.itsthesky.disky.elements.structures.slash.models.ParsedArgument;

public class ParsedCommand {
    private List<ParsedArgument> arguments = new ArrayList<ParsedArgument>();
    private String description;
    private Map<DiscordLocale, String> descriptionLocalizations = new HashMap<DiscordLocale, String>();
    private String originalName;
    private String name;
    private Map<DiscordLocale, String> nameLocalizations = new HashMap<DiscordLocale, String>();
    private List<Permission> enabledFor = new ArrayList<Permission>();
    private boolean disabledByDefault = false;
    private String rawBot;
    private Bot bot;
    private List<String> guilds = new ArrayList<String>();
    private long cooldown;
    private Trigger onCooldown;
    private Trigger trigger;

    public String getOriginalName() {
        return this.originalName != null ? this.originalName : this.name;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public List<ParsedArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<ParsedArgument> arguments) {
        this.arguments = arguments;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<DiscordLocale, String> getDescriptionLocalizations() {
        return this.descriptionLocalizations;
    }

    public void setDescriptionLocalizations(Map<DiscordLocale, String> descriptionLocalizations) {
        this.descriptionLocalizations = descriptionLocalizations;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<DiscordLocale, String> getNameLocalizations() {
        return this.nameLocalizations;
    }

    public void setNameLocalizations(Map<DiscordLocale, String> nameLocalizations) {
        this.nameLocalizations = nameLocalizations;
    }

    public void setEnabledFor(List<Permission> enabledFor) {
        this.enabledFor = enabledFor;
    }

    public List<Permission> getEnabledFor() {
        return this.enabledFor;
    }

    public void setDisabledByDefault(boolean disabledByDefault) {
        this.disabledByDefault = disabledByDefault;
    }

    public boolean isDisabledByDefault() {
        return this.disabledByDefault;
    }

    public Bot getBot() {
        return this.bot;
    }

    public void setBot(Bot bot) {
        this.bot = bot;
    }

    public List<String> getGuilds() {
        return this.guilds;
    }

    public void addGuild(String guild) {
        this.guilds.add(guild);
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public String getRawBot() {
        return this.rawBot;
    }

    public void setRawBot(String rawBot) {
        this.rawBot = rawBot;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(long cooldown) {
        this.cooldown = cooldown;
    }

    public Trigger getOnCooldown() {
        return this.onCooldown;
    }

    public void setOnCooldown(Trigger onCooldown) {
        this.onCooldown = onCooldown;
    }

    public boolean hasCooldown() {
        return this.cooldown > 0L || this.onCooldown != null;
    }

    public boolean shouldUpdate(ParsedCommand command) {
        return true;
    }

    public void prepareArguments(SlashCommandInteractionEvent event) {
        List<OptionMapping> options = event.getOptions();
        DiSky.debug("Found '" + this.arguments.size() + " args' for '" + options.size() + " options'");
        for (ParsedArgument argument : this.arguments) {
            OptionMapping option = options.stream().filter(opt -> opt.getName().equals(argument.getName())).findFirst().orElse(null);
            if (option == null) {
                argument.setValue(null);
                continue;
            }
            if (argument.getCustomArgument() != null) {
                CustomArgument<?> customArgument = argument.getCustomArgument();
                Object value = customArgument.convert(event, option);
                argument.setValue(value);
                continue;
            }
            argument.setValue(JDAUtils.parseOptionValue(option));
        }
    }

    public void prepareArguments(CommandAutoCompleteInteractionEvent event) {
        List<OptionMapping> options = event.getOptions();
        DiSky.debug("Found '" + this.arguments.size() + " args' for '" + options.size() + " options'");
        for (ParsedArgument argument : this.arguments) {
            OptionMapping option = options.stream().filter(opt -> opt.getName().equals(argument.getName())).findFirst().orElse(null);
            if (option == null) {
                argument.setValue(null);
                continue;
            }
            if (argument.getCustomArgument() != null) {
                CustomArgument<?> customArgument = argument.getCustomArgument();
                Object value = customArgument.convert(event, option);
                argument.setValue(value);
                continue;
            }
            argument.setValue(JDAUtils.parseOptionValue(option));
        }
    }
}

