/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash.models;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.entities.User;
import net.itsthesky.disky.elements.structures.slash.models.ParsedCommand;

public class RegisteredCommand {
    private ParsedCommand parsedCommand;
    private List<ParsedCommand> subCommands;
    private final long commandId;
    private final String botName;
    private final String guildId;
    private final Map<User, Long> cooldowns;

    public RegisteredCommand(ParsedCommand parsedCommand, long commandId, String botName, String guildId) {
        this.parsedCommand = parsedCommand;
        this.commandId = commandId;
        this.botName = botName;
        this.guildId = guildId;
        this.cooldowns = new HashMap<User, Long>();
    }

    public long getCommandId() {
        return this.commandId;
    }

    public String getBotName() {
        return this.botName;
    }

    public String getGuildId() {
        return this.guildId;
    }

    public boolean isInCooldown(User user) {
        return this.cooldowns.containsKey(user) && this.cooldowns.get(user) > System.currentTimeMillis();
    }

    public long getCooldown(User user) {
        return this.cooldowns.getOrDefault(user, 0L);
    }

    public void setCooldown(User user) {
        this.cooldowns.put(user, System.currentTimeMillis() + this.getParsedCommand().getCooldown());
    }

    public ParsedCommand getParsedCommand() {
        return this.parsedCommand;
    }

    public void setParsedCommand(ParsedCommand parsedCommand) {
        this.parsedCommand = parsedCommand;
    }

    public String getName() {
        return this.parsedCommand == null ? "" : this.parsedCommand.getName();
    }
}

