/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash.models;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.dv8tion.jda.api.entities.User;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.elements.structures.slash.models.CommandGroup;
import net.itsthesky.disky.elements.structures.slash.models.CommandType;
import net.itsthesky.disky.elements.structures.slash.models.ParsedCommand;

public class RegisteredGroup {
    private final CommandGroup commandGroup;
    private final long commandId;
    private final String botName;
    private final String guildId;
    private final Map<String, Map<User, Long>> cooldowns = new HashMap<String, Map<User, Long>>();

    public RegisteredGroup(CommandGroup commandGroup, long commandId, String botName, String guildId) {
        this.commandGroup = commandGroup;
        this.commandId = commandId;
        this.botName = botName;
        this.guildId = guildId;
    }

    public boolean isInCooldown(User user, String commandPath) {
        Map<User, Long> commandCooldowns = this.cooldowns.get(commandPath);
        if (commandCooldowns == null) {
            return false;
        }
        Long cooldownEnd = commandCooldowns.get(user);
        return cooldownEnd != null && cooldownEnd > System.currentTimeMillis();
    }

    public long getCooldown(User user, String commandPath) {
        Map<User, Long> commandCooldowns = this.cooldowns.get(commandPath);
        if (commandCooldowns == null) {
            return 0L;
        }
        Long cooldownEnd = commandCooldowns.get(user);
        return cooldownEnd != null ? Math.max(0L, cooldownEnd - System.currentTimeMillis()) : 0L;
    }

    public void setCooldown(User user, String commandPath, long cooldownDuration) {
        this.cooldowns.computeIfAbsent(commandPath, k -> new HashMap()).put(user, System.currentTimeMillis() + cooldownDuration);
    }

    public ParsedCommand findCommand(String commandPath) {
        String[] parts = commandPath.split(" ");
        if (parts.length == 1) {
            if (this.commandGroup.getType() == CommandType.SINGLE) {
                return this.commandGroup.getSingleCommand();
            }
            return null;
        }
        if (parts.length == 2) {
            return this.commandGroup.getSubCommands().get(parts[1]);
        }
        if (parts.length == 3) {
            CommandGroup subGroup = this.commandGroup.getSubGroups().get(parts[1]);
            if (subGroup == null) {
                DiSky.debug("Subgroup '" + parts[1] + "' not found in command group '" + this.commandGroup.getName() + "'");
                return null;
            }
            ParsedCommand cmd = subGroup.getSubCommands().get(parts[2]);
            if (cmd == null) {
                DiSky.debug("Command '" + parts[2] + "' not found in subgroup '" + parts[1] + "'");
            }
            return cmd;
        }
        DiSky.debug("Invalid command path: " + commandPath + " (too many parts)");
        return null;
    }

    public void clearCooldowns() {
        this.cooldowns.clear();
    }

    public CommandGroup getCommandGroup() {
        return this.commandGroup;
    }

    public long getCommandId() {
        return this.commandId;
    }

    public String getBotName() {
        return this.botName;
    }

    public String getGuildId() {
        return this.guildId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredGroup that = (RegisteredGroup)o;
        return this.commandId == that.commandId && Objects.equals(this.botName, that.botName) && Objects.equals(this.guildId, that.guildId);
    }

    public int hashCode() {
        return Objects.hash(this.commandId, this.botName, this.guildId);
    }

    public String toString() {
        return "RegisteredGroup{name='" + this.commandGroup.getName() + "', commandId=" + this.commandId + ", botName='" + this.botName + "', guildId='" + this.guildId + "'}";
    }
}

