/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.managers;

import java.util.HashMap;
import java.util.function.BiFunction;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.concrete.NewsChannel;
import net.dv8tion.jda.api.entities.channel.concrete.StageChannel;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.itsthesky.disky.core.Bot;

public class BotChangers {
    public static final HashMap<Class<?>, BiFunction<?, Bot, ?>> CONVERTERS = new HashMap();

    private static <T> void register(BiFunction<T, Bot, T> converter, Class<T> clazz) {
        CONVERTERS.put(clazz, converter);
    }

    public static <T> T convert(T entity, Bot bot) {
        BiFunction converter = CONVERTERS.getOrDefault(entity.getClass().getInterfaces()[0], null);
        if (converter == null) {
            return null;
        }
        return (T)converter.apply(entity, bot);
    }

    private static <T> void register(Class<T> clazz, BiFunction<T, Bot, T> converter) {
        CONVERTERS.put(clazz, converter);
    }

    public static void init() {
        BotChangers.register(Guild.class, (T entity, Bot bot) -> bot.getInstance().getGuildById(entity.getId()));
        BotChangers.register(User.class, (T entity, Bot bot) -> bot.getInstance().getUserById(entity.getId()));
        BotChangers.register(Member.class, (T entity, Bot bot) -> bot.getInstance().getGuildById(entity.getGuild().getId()).getMemberById(entity.getId()));
        BotChangers.register(GuildChannel.class, (T entity, Bot bot) -> bot.getInstance().getGuildChannelById(entity.getId()));
        BotChangers.register(TextChannel.class, (T entity, Bot bot) -> bot.getInstance().getTextChannelById(entity.getId()));
        BotChangers.register(NewsChannel.class, (T entity, Bot bot) -> bot.getInstance().getNewsChannelById(entity.getId()));
        BotChangers.register(StageChannel.class, (T entity, Bot bot) -> bot.getInstance().getStageChannelById(entity.getId()));
        BotChangers.register(ThreadChannel.class, (T entity, Bot bot) -> bot.getInstance().getThreadChannelById(entity.getId()));
        BotChangers.register(VoiceChannel.class, (T entity, Bot bot) -> bot.getInstance().getVoiceChannelById(entity.getId()));
        BotChangers.register(Message.class, (T entity, Bot bot) -> bot.getInstance().getGuildById(entity.getGuild().getId()).getTextChannelById(entity.getChannel().asGuildMessageChannel().getId()).getHistory().getMessageById(entity.getId()));
    }
}

