/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.managers;

import com.google.common.collect.Sets;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.events.session.ShutdownEvent;
import net.itsthesky.disky.api.skript.ErrorHandler;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.MemberRemoveEventListener;
import net.itsthesky.disky.core.ReactionListener;
import net.itsthesky.disky.elements.commands.CommandListener;
import net.itsthesky.disky.managers.CoreEventListener;
import net.itsthesky.disky.managers.DiSkyErrorHandler;
import net.itsthesky.disky.managers.MessageManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class BotManager {
    private boolean anyBotEnabled = false;
    private final JavaPlugin plugin;
    private final Set<Bot> bots = Sets.newConcurrentHashSet();

    public BotManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public Set<Bot> getBots() {
        return this.bots;
    }

    public void addBot(Bot bot) {
        this.bots.removeIf(b -> b.getName().equals(bot.getName()));
        this.configureBot(bot);
        this.anyBotEnabled = true;
        this.bots.add(bot);
    }

    private void configureBot(Bot bot) {
        bot.getInstance().addEventListener(new CommandListener());
        bot.getInstance().addEventListener(new ReactionListener());
        bot.getInstance().addEventListener(new MessageManager(bot));
        bot.getInstance().addEventListener(new MemberRemoveEventListener());
        bot.getInstance().addEventListener(new CoreEventListener(bot));
    }

    public void shutdown() {
        for (Bot bot : this.bots) {
            Thread thread = new Thread(() -> bot.getOptions().runShutdown(new ShutdownEvent(bot.getInstance(), OffsetDateTime.now(), 0)));
            thread.start();
            new Thread(() -> {
                while (thread.isAlive()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                bot.getInstance().shutdown();
            }).start();
        }
    }

    public boolean exist(@Nullable String name) {
        return name != null && this.bots.stream().anyMatch(bot -> bot.getName().equals(name));
    }

    public void execute(Consumer<Bot> consumer) {
        this.bots.forEach(consumer);
    }

    public ErrorHandler errorHandler() {
        return new DiSkyErrorHandler();
    }

    @Nullable
    public Bot fromName(String name) {
        return this.bots.stream().filter(bot -> bot.getName().equals(name)).findAny().orElse(null);
    }

    @Nullable
    public <T> T searchIfAnyPresent(Function<Bot, T> function) {
        if (this.findAny() == null) {
            return null;
        }
        return function.apply(this.findAny());
    }

    @Nullable
    public Bot findAny() {
        return this.getBots().stream().findAny().orElse(null);
    }

    public final String getJDAName(JDA core) {
        return this.bots.stream().filter(bot -> bot.coreIsEquals(core)).map(Bot::getName).findAny().orElse(null);
    }

    public Bot fromJDA(JDA core) {
        return this.bots.stream().filter(bot -> bot.getInstance().equals(core)).findAny().orElse(null);
    }

    public void removeBot(Bot bot) {
        Set set = new HashSet<Bot>(this.bots).stream().filter(bot1 -> !bot1.getName().equalsIgnoreCase(bot.getName())).collect(Collectors.toSet());
        this.bots.clear();
        this.bots.addAll(set);
    }

    public Bot getBotByName(String name) {
        return this.bots.stream().filter(bot -> bot.getName().equalsIgnoreCase(name)).findAny().orElse(null);
    }
}

