/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.managers;

import ch.njol.skript.config.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.dv8tion.jda.api.requests.ErrorResponse;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.ErrorHandler;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.core.Utils;
import net.itsthesky.disky.elements.events.DiSkyErrorEvent;
import net.itsthesky.disky.managers.ConfigManager;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiSkyErrorHandler
implements ErrorHandler {
    private final HashMap<ErrorResponse, Function<Throwable, String[]>> errors = new HashMap();
    private final HashMap<Event, Throwable> errorsValue = new HashMap();
    private final Function<Throwable, String[]> def;
    private final HashMap<ErrorResponse, String> friendlyMessages = new HashMap();
    private final List<String> QUEUED_MESSAGES = new ArrayList<String>();

    public DiSkyErrorHandler() {
        this.def = ex -> {
            ArrayList<String> msg = new ArrayList<String>(Arrays.asList(ex.getMessage().split("\n")));
            msg.add("");
            msg.add("&4Full Stacktrace:");
            msg.add("");
            for (StackTraceElement line : ex.getStackTrace()) {
                msg.add(line.toString());
            }
            msg.add("");
            msg.add("&6&lREAD THE ERROR CAREFULLY&r&e, and if you are sure about it,");
            msg.add("&eyou can report the error with the whole stacktrace on the GitHub repository:");
            msg.add("&ehttps://github.com/DiSkyOrg/DiSky/issues/new");
            msg.add("");
            return msg.toArray(new String[0]);
        };
        this.errors.put(ErrorResponse.INVALID_FORM_BODY, ex -> {
            ArrayList<String> msg = new ArrayList<String>();
            ArrayList<String> oldMsg = new ArrayList<String>(Arrays.asList(ex.getMessage().split("\n")));
            oldMsg.remove(0);
            msg.add("Invalid component configuration: ");
            msg.add("");
            String previous = "";
            for (String m : oldMsg) {
                if (previous.contains("-") && !m.contains("-")) {
                    msg.add("");
                }
                msg.add(m);
                previous = m;
            }
            if (ConfigManager.get("debug", false).booleanValue()) {
                msg.add("");
                msg.add("&4Full Stacktrace:");
                msg.add("");
                for (StackTraceElement line : ex.getStackTrace()) {
                    msg.add(line.toString());
                }
            }
            return msg.toArray(new String[0]);
        });
        this.friendlyMessages.put(ErrorResponse.UNKNOWN_USER, "The specified user does not exist or is not cached.");
        this.friendlyMessages.put(ErrorResponse.UNKNOWN_CHANNEL, "The specified channel does not exist or is not cached.");
        this.friendlyMessages.put(ErrorResponse.UNKNOWN_GUILD, "The specified guild does not exist or is not cached.");
        this.friendlyMessages.put(ErrorResponse.UNKNOWN_MEMBER, "The specified member does not exist or is not cached.");
        this.friendlyMessages.put(ErrorResponse.UNKNOWN_ROLE, "The specified role does not exist or is not cached.");
        this.friendlyMessages.put(ErrorResponse.UNKNOWN_EMOJI, "The specified emoji does not exist or is not cached.");
        this.friendlyMessages.put(ErrorResponse.UNKNOWN_WEBHOOK, "The specified webhook does not exist or is not cached.");
        this.friendlyMessages.put(ErrorResponse.UNKNOWN_BAN, "The specified ban does not exist or is not cached.");
        this.friendlyMessages.put(ErrorResponse.UNKNOWN_INTEGRATION, "The specified integration does not exist or is not cached.");
        this.friendlyMessages.put(ErrorResponse.UNKNOWN_INVITE, "The specified invite does not exist or is not cached.");
        this.friendlyMessages.put(ErrorResponse.UNKNOWN_MESSAGE, "The specified message does not exist or is not cached.");
    }

    @Override
    public void exception(@Nullable Event event, @Nullable Throwable ex, @Nullable Node node) {
        this.insertErrorValue(event, ex);
        this.send("&4[&c!&4] &c");
        this.send("&4[&c!&4] &4DiSky Internal Error (version: " + DiSky.getInstance().getDescription().getVersion() + ")");
        if (ex != null) {
            this.send("&4[&c!&4] &4Error type: &c" + ex.getClass().getSimpleName());
        }
        this.send("&4[&c!&4] &c");
        if (ex == null) {
            ex = new RuntimeException("Unknown exception (nullable message): " + String.valueOf(ex));
        }
        String[] lines = ex instanceof ErrorResponseException ? this.formatResponseError((ErrorResponseException)ex) : this.def.apply(ex);
        if (event != null) {
            Throwable finalEx = ex;
            SkriptUtils.sync(() -> Bukkit.getPluginManager().callEvent((Event)new DiSkyErrorEvent.BukkitDiSkyErrorEvent(finalEx, event.getEventName())));
        }
        if (lines == null) {
            this.QUEUED_MESSAGES.clear();
            return;
        }
        for (String line : lines) {
            this.send("&4[&c!&4] &c" + line);
        }
        if (node != null) {
            this.send("&4[&c!&4] &c");
            this.send("&4[&c!&4] &4Error occurred in the following node:");
            this.send("&4[&c!&4] &c");
            this.send("&4[&c!&4] &c" + node.getKey() + " &6(" + node.getConfig().getFileName() + ", line " + node.getLine() + ")");
            this.send("&4[&c!&4] &c");
        }
        this.send("&4[&c!&4] &c");
        this.sendAll();
    }

    @Override
    public void insertErrorValue(@Nullable Event event, @Nullable Throwable error) {
        if (event != null) {
            this.errorsValue.put(event, error);
        }
    }

    @Override
    @Nullable
    public Throwable getErrorValue(@NotNull Event event) {
        Throwable value = this.errorsValue.getOrDefault(event, null);
        this.errorsValue.remove(event);
        return value;
    }

    public String[] formatResponseError(ErrorResponseException ex) {
        if (ConfigManager.getIgnoredCodes().contains(ex.getErrorCode())) {
            return null;
        }
        if (!this.errors.containsKey((Object)ex.getErrorResponse())) {
            return this.def.apply(ex);
        }
        return this.errors.get((Object)ex.getErrorResponse()).apply(ex);
    }

    private void send(String message2) {
        this.QUEUED_MESSAGES.add(Utils.colored(message2));
    }

    private void sendAll() {
        Bukkit.getConsoleSender().sendMessage(this.QUEUED_MESSAGES.toArray(new String[0]));
        this.QUEUED_MESSAGES.clear();
    }
}

