/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.managers;

import java.util.HashMap;
import java.util.Map;
import net.dv8tion.jda.api.entities.IncomingWebhookClient;
import net.dv8tion.jda.api.entities.WebhookClient;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.managers.wrappers.RegisteredWebhook;
import org.jetbrains.annotations.Nullable;

public final class WebhooksManager {
    private final DiSky instance;
    private final Map<String, RegisteredWebhook> webhooks;

    public WebhooksManager(DiSky instance) {
        this.instance = instance;
        this.webhooks = new HashMap<String, RegisteredWebhook>();
    }

    public void registerWebhook(Bot bot, String name, String url) {
        IncomingWebhookClient client = WebhookClient.createClient(bot.getInstance(), url);
        RegisteredWebhook webhook = new RegisteredWebhook(name, bot, client);
        this.webhooks.put(name, webhook);
    }

    public void unregisterWebhook(String name) {
        if (!this.webhooks.containsKey(name)) {
            return;
        }
        this.webhooks.remove(name);
    }

    public boolean isWebhookRegistered(String name) {
        return this.webhooks.containsKey(name);
    }

    public RegisteredWebhook getWebhook(String name) {
        return this.webhooks.get(name);
    }

    @Nullable
    public RegisteredWebhook getWebhookById(String id) {
        return this.webhooks.values().stream().filter(webhook -> webhook.getClient().getId().equals(id)).findFirst().orElse(null);
    }
}

