/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.api.ReflectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiSkyType<T> {
    public static final List<DiSkyType<?>> DISKY_CLASSES = new ArrayList();
    private final Class<T> clazz;
    private final String codeName;
    private final String user;
    private final Function<T, String> toString;
    private final Function<String, T> parser;
    private final boolean isEnum;
    private final ClassInfo<T> classInfo;
    @Nullable
    private Function<String, RestAction<T>> restParser;

    public DiSkyType(Class<T> clazz, String codeName, Function<T, String> toString, @Nullable Function<String, T> parser) {
        this(clazz, codeName, codeName, toString, parser, false);
    }

    public DiSkyType(Class<T> clazz, String codeName, Function<T, String> toString, @Nullable Function<String, T> parser, boolean allowFullParsing) {
        this(clazz, codeName, codeName, toString, parser, allowFullParsing);
    }

    public DiSkyType(Class<T> clazz, String codeName, String user, final Function<T, String> toString, final @Nullable Function<String, T> parser, final boolean isEnum) {
        this.clazz = clazz;
        this.codeName = codeName;
        this.user = user;
        this.toString = toString;
        this.parser = parser;
        this.isEnum = isEnum;
        this.classInfo = new DiSkyTypeWrapper<T>(clazz, codeName).diskyType(this).user(new String[]{user}).parser(new Parser<T>(){

            @NotNull
            public T parse(@NotNull String input, @NotNull ParseContext context) {
                if (parser == null) {
                    return null;
                }
                if (isEnum) {
                    try {
                        return parser.apply(input);
                    }
                    catch (Exception ignored) {
                        return null;
                    }
                }
                if (context.equals((Object)ParseContext.COMMAND)) {
                    return parser.apply(DiSkyType.this.parse(input));
                }
                return null;
            }

            public boolean canParse(@NotNull ParseContext context) {
                if (parser == null) {
                    return false;
                }
                if (isEnum) {
                    return true;
                }
                return context.equals((Object)ParseContext.COMMAND);
            }

            @NotNull
            public String toString(T entity, int flags) {
                try {
                    return (String)toString.apply(entity);
                }
                catch (Exception ex) {
                    return entity.toString();
                }
            }

            @NotNull
            public String toVariableNameString(T entity) {
                if (entity instanceof ISnowflake) {
                    ISnowflake snowflake = (ISnowflake)entity;
                    return snowflake.getId();
                }
                if (entity instanceof Component) {
                    Component component = (Component)entity;
                    return Integer.toString(component.getUniqueId());
                }
                if (entity instanceof Enum) {
                    Enum enumValue = (Enum)entity;
                    return enumValue.name().toLowerCase(Locale.ROOT).replaceAll("_", " ");
                }
                return this.toString(entity, 0);
            }
        });
    }

    public static <T extends Enum> Parser<T> createParser(final Class<T> enumClass) {
        return new Parser<T>(){

            @NotNull
            public String toString(T o, int flags) {
                return ((Enum)o).name().toLowerCase(Locale.ROOT).replaceAll("_", " ");
            }

            @NotNull
            public String toVariableNameString(T o) {
                return this.toString((T)o, 0);
            }

            public boolean canParse(@NotNull ParseContext context) {
                return true;
            }

            public T parse(@NotNull String s, @NotNull ParseContext context) {
                return Enum.valueOf(enumClass, s.toUpperCase(Locale.ROOT).replaceAll(" ", "_"));
            }
        };
    }

    public static <T extends Enum<?>> DiSkyType<T> fromEnum(Class<T> enumClass, String typeName, String user) {
        return DiSkyType.fromEnum(enumClass, typeName, user, null);
    }

    public static <T extends Enum<?>> DiSkyType<T> fromEnum(Class<T> enumClass, String typeName, String user, @Nullable String suffix) {
        DiSkyType<Enum> type = new DiSkyType<Enum>(enumClass, typeName, user, entity -> entity.name().toLowerCase(Locale.ROOT).replaceAll("_", " "), input -> {
            if (suffix != null && !input.endsWith(suffix)) {
                return null;
            }
            if (suffix != null) {
                input = input.substring(0, input.length() - suffix.length());
            }
            try {
                return (Enum)ReflectionUtils.invokeMethodEx(enumClass, "valueOf", null, input.toUpperCase(Locale.ROOT).replaceAll(" ", "_"));
            }
            catch (Exception ex) {
                return null;
            }
        }, true);
        CharSequence[] formatted = (String[])Arrays.stream((Enum[])enumClass.getEnumConstants()).map(value -> value.name().replaceAll("_", " ").toLowerCase(Locale.ROOT)).map(value -> {
            if (suffix != null) {
                return value + suffix;
            }
            return value;
        }).toArray(String[]::new);
        type.classInfo.examples(new String[]{String.join((CharSequence)", ", formatted)});
        return type;
    }

    private String parse(String input) {
        return input.replaceAll("[@{}<>&!#~]+", "");
    }

    public void register(ClassInfo<T> classInfo) {
        DISKY_CLASSES.add(this);
        Classes.registerClass(classInfo);
    }

    public void register() {
        this.register(this.classInfo);
    }

    public void register(Consumer<ClassInfo<T>> consumer) {
        consumer.accept(this.classInfo);
        this.register();
    }

    public DiSkyType<T> eventExpression() {
        this.classInfo.defaultExpression((DefaultExpression)new EventValueExpression(this.clazz));
        return this;
    }

    public DiSkyType<T> createRestParser(Function<String, RestAction<T>> parser) {
        this.restParser = parser;
        return this;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public ClassInfo<T> getClassInfo() {
        return this.classInfo;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public Class<? extends Enum> getEnumClass() {
        return this.clazz;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getUser() {
        return this.user;
    }

    public Function<String, T> getParser() {
        return this.parser;
    }

    public Function<T, String> getToString() {
        return this.toString;
    }

    @Nullable
    public Function<String, RestAction<T>> getRestParser() {
        return this.restParser;
    }

    public static class DiSkyTypeWrapper<T>
    extends ClassInfo<T> {
        private DiSkyType<T> diSkyType;

        public DiSkyTypeWrapper(Class<T> c, String codeName) {
            super(c, codeName);
        }

        public DiSkyType<T> getDiSkyType() {
            return this.diSkyType;
        }

        public DiSkyTypeWrapper<T> diskyType(DiSkyType<T> diSkyType) {
            this.diSkyType = diSkyType;
            return this;
        }
    }
}

