/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.datastruct;

import ch.njol.skript.lang.ExpressionType;
import java.util.concurrent.atomic.AtomicInteger;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.matcher.ElementMatchers;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.DiSkyRegistry;
import net.itsthesky.disky.api.datastruct.ReflectBasicDataStructure;
import net.itsthesky.disky.api.datastruct.base.DataStruct;

public class EasyDSRegistry {
    private static final AtomicInteger COUNT = new AtomicInteger(0);

    public static <T, D extends DataStruct<T>> void registerBasicDataStructure(Class<D> clazz, Class<T> returnType, String pattern, String toString) {
        try {
            Class elementClass = new ByteBuddy().redefine(ReflectBasicDataStructure.class).name("net.itsthesky.disky.elements.reflects.ReflectDataStructureElement_" + COUNT.incrementAndGet()).method(ElementMatchers.named("getReturnType")).intercept(MethodDelegation.to(new ReturnClassMethodInterceptor(returnType))).method(ElementMatchers.named("getDataStructClass")).intercept(MethodDelegation.to(new ReturnClassMethodInterceptor(clazz))).method(ElementMatchers.named("toString")).intercept(MethodDelegation.to(new ReturnStringMethodInterceptor(toString))).make().load(clazz.getClassLoader()).getLoaded();
            DiSkyRegistry.registerExpression(elementClass, returnType, ExpressionType.SIMPLE, pattern);
            DiSky.debug("Registered new data structure element: " + elementClass.getSimpleName() + " with pattern: " + pattern);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class ReturnClassMethodInterceptor {
        private final Class<?> returnType;

        public ReturnClassMethodInterceptor(Class<?> returnType) {
            this.returnType = returnType;
        }

        @RuntimeType
        public Object intercept(@AllArguments Object[] allArguments) {
            return this.returnType;
        }
    }

    public static class ReturnStringMethodInterceptor {
        private final String returnString;

        public ReturnStringMethodInterceptor(String returnString) {
            this.returnString = returnString;
        }

        @RuntimeType
        public Object intercept(@AllArguments Object[] allArguments) {
            return this.returnString;
        }
    }
}

