/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.datastruct;

import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.itsthesky.disky.api.datastruct.DataStructureFactory;
import net.itsthesky.disky.api.datastruct.base.DataStruct;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;

public abstract class EditDataStructElement<T, D extends DataStruct<T>>
extends Section {
    protected EntryContainer container;
    protected Map<String, List<Expression<?>>> expressions;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode node, List<TriggerItem> triggerItems) {
        EntryValidator validator = DataStructureFactory.createValidator(this.getDataStructClass());
        this.container = validator.validate(node);
        ArrayList<String> presentNodes = new ArrayList<String>();
        if (this.container != null) {
            for (EntryData entryData : validator.getEntryData()) {
                if (!this.container.hasEntry(entryData.getKey())) continue;
                presentNodes.add(entryData.getKey());
            }
        }
        this.expressions = new HashMap();
        for (String nodeKey : presentNodes) {
            this.container.getOptional(nodeKey, List.class, true);
        }
        String errorMessage = DataStructureFactory.preValidate(this.getDataStructClass(), presentNodes);
        if (errorMessage != null) {
            DiSkyRuntimeHandler.error(new IllegalStateException(errorMessage), (Node)node);
            return false;
        }
        return this.container != null;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        return null;
    }

    public abstract Class<D> getDataStructClass();
}

