/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.emojis;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.itsthesky.disky.api.emojis.Action;
import net.itsthesky.disky.api.emojis.ActionImpl;
import net.itsthesky.disky.api.emojis.ExtendedEmoji;
import net.itsthesky.disky.api.emojis.TwemojiType;
import net.itsthesky.disky.core.Utils;
import org.jetbrains.annotations.NotNull;

public final class Emoji {
    private final String subpage;
    private final String unicode;
    private final List<String> shortcodes;
    private final boolean supportsFitzpatrick;

    public Emoji(@NotNull String subpage, @NotNull String unicode, @NotNull List<String> shortcodes, boolean supportsFitzpatrick) {
        this.subpage = subpage;
        this.unicode = unicode;
        this.shortcodes = shortcodes;
        this.supportsFitzpatrick = supportsFitzpatrick;
        for (String shortcode : shortcodes) {
            if (!shortcode.contains(":")) continue;
            throw new IllegalArgumentException(": not allowed in shortcode " + shortcode);
        }
    }

    public String subpage() {
        return this.subpage;
    }

    public String unicode() {
        return this.unicode;
    }

    public List<String> shortcodes() {
        return this.shortcodes;
    }

    public boolean doesSupportFitzpatrick() {
        return this.supportsFitzpatrick;
    }

    public Action<ExtendedEmoji> retrieveExtendedInfo() {
        return new ActionImpl<ExtendedEmoji>(() -> ExtendedEmoji.of(this));
    }

    public List<String> getUTF16() {
        int[] codepoints = this.unicode.codePoints().toArray();
        ArrayList<String> list = new ArrayList<String>();
        for (int codePoint : codepoints) {
            char[] chars;
            for (char aChar : chars = Character.toChars(codePoint)) {
                String hex = Integer.toHexString(aChar).toUpperCase();
                if (hex.equals("FE0F")) continue;
                list.add("\\u" + Utils.repeat("0", 4 - hex.length()) + hex);
            }
        }
        return list;
    }

    public List<Character> getUTF16Unescaped() {
        int[] codepoints = this.unicode.codePoints().toArray();
        ArrayList<Character> list = new ArrayList<Character>();
        for (int codePoint : codepoints) {
            char[] chars;
            for (char aChar : chars = Character.toChars(codePoint)) {
                if (aChar == '\ufe0f') continue;
                list.add(Character.valueOf(aChar));
            }
        }
        return list;
    }

    public List<String> getUnicodeCodepoints() {
        return this.unicode.codePoints().mapToObj(codepoint -> "U+" + Integer.toHexString(codepoint).toUpperCase()).collect(Collectors.toList());
    }

    public List<String> getHexCodepoints() {
        return this.unicode.codePoints().mapToObj(Integer::toHexString).collect(Collectors.toList());
    }

    public String getTwemojiImageUrl(TwemojiType type) {
        String folder = type == TwemojiType.X72 ? "72x72" : "svg";
        String extension = type == TwemojiType.X72 ? ".png" : ".svg";
        return "https://raw.githubusercontent.com/twitter/twemoji/master/assets/" + folder + "/" + String.join((CharSequence)"-", this.getHexCodepoints()) + extension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Emoji emoji = (Emoji)o;
        if (this.supportsFitzpatrick != emoji.supportsFitzpatrick) {
            return false;
        }
        if (!this.subpage.equals(emoji.subpage)) {
            return false;
        }
        if (!this.unicode.equals(emoji.unicode)) {
            return false;
        }
        return this.shortcodes.equals(emoji.shortcodes);
    }

    public int hashCode() {
        int result2 = this.subpage.hashCode();
        result2 = 31 * result2 + this.unicode.hashCode();
        result2 = 31 * result2 + this.shortcodes.hashCode();
        result2 = 31 * result2 + (this.supportsFitzpatrick ? 1 : 0);
        return result2;
    }

    public String toString() {
        return "Emoji{subpage='" + this.subpage + "', unicode='" + this.unicode + "', shortcodes=" + String.valueOf(this.shortcodes) + ", supportsFitzpatrick=" + this.supportsFitzpatrick + "}";
    }
}

