/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.emojis;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.itsthesky.disky.api.emojis.Emoji;
import net.itsthesky.disky.api.emojis.Emojis;

public class EmojiParser {
    private static final Pattern SHORTCODE_PATTERN = Pattern.compile(":(.+?|[+-]1):");

    public static String toUnicode(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        Matcher matcher = SHORTCODE_PATTERN.matcher(str);
        int start = 0;
        while (matcher.find()) {
            String shortcode = matcher.group(1);
            sb.append(str, start, matcher.start());
            Emoji emoji = Emojis.ofShortcode(shortcode);
            if (emoji != null) {
                sb.append(emoji.unicode());
            } else {
                sb.append(matcher.group());
            }
            start = matcher.end();
        }
        sb.append(str, start, str.length());
        return sb.toString();
    }
}

