/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.emojis;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.emojis.Emoji;

public class EmojiStore {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Set<Emoji> emojis = new HashSet<Emoji>();

    public static EmojiStore loadLocal() throws IOException {
        EmojiStore store;
        DiSky.debug("Loading local emojis");
        File file = new File(DiSky.getInstance().getDataFolder(), "emojis.json");
        try (FileInputStream fis = new FileInputStream(file);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(isr);){
            store = GSON.fromJson((Reader)reader, EmojiStore.class);
        }
        DiSky.debug("Loaded " + store.getEmojis().size() + " local emojis");
        return store;
    }

    public Set<Emoji> getEmojis() {
        return this.emojis;
    }
}

