/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.emojis;

import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.entities.emoji.RichCustomEmoji;
import net.dv8tion.jda.api.entities.emoji.UnicodeEmoji;
import net.dv8tion.jda.api.requests.RestAction;
import org.jetbrains.annotations.NotNull;

public class Emote
implements IMentionable {
    private final CustomEmoji customEmoji;
    private final UnicodeEmoji unicodeEmoji;
    private final Emoji emoji;

    public Emote(Emoji emoji) {
        this.emoji = emoji;
        this.customEmoji = emoji.getType().equals((Object)Emoji.Type.CUSTOM) ? (CustomEmoji)emoji : null;
        this.unicodeEmoji = emoji.getType().equals((Object)Emoji.Type.UNICODE) ? (UnicodeEmoji)emoji : null;
    }

    public static Emote fromUnion(EmojiUnion emote) {
        if (emote == null) {
            return null;
        }
        if (emote.getType().equals((Object)Emoji.Type.CUSTOM)) {
            return new Emote(emote.asCustom());
        }
        return new Emote(Emoji.fromUnicode(emote.getName()));
    }

    public static Emote fromJDA(CustomEmoji emote) {
        if (emote == null) {
            return null;
        }
        return new Emote(emote);
    }

    public RestAction<Void> addReaction(Message message2) {
        return message2.addReaction(this.getEmoji());
    }

    public String toString() {
        return this.getName();
    }

    public UnicodeEmoji getUnicodeEmoji() {
        return this.unicodeEmoji;
    }

    public RichCustomEmoji getEmote() {
        return this.customEmoji instanceof RichCustomEmoji ? (RichCustomEmoji)this.customEmoji : null;
    }

    public String getName() {
        return this.emoji.getName();
    }

    @Override
    @NotNull
    public String getId() {
        return this.getID();
    }

    public boolean isCustom() {
        return this.emoji.getType().equals((Object)Emoji.Type.CUSTOM);
    }

    public Emoji getEmoji() {
        return this.emoji;
    }

    public boolean isAnimated() {
        return this.customEmoji != null && this.customEmoji.isAnimated();
    }

    public String getID() {
        return this.isCustom() ? this.customEmoji.getId() : this.unicodeEmoji.getName();
    }

    public Guild getGuild() {
        return this.isCustom() && this.customEmoji instanceof RichCustomEmoji ? ((RichCustomEmoji)this.customEmoji).getGuild() : null;
    }

    @Override
    @NotNull
    public String getAsMention() {
        if (this.isCustom()) {
            return "<" + (this.isAnimated() ? "a" : "") + ":" + this.getName() + ":" + this.getID() + ">";
        }
        return this.getName();
    }

    @Override
    public long getIdLong() {
        return Long.parseLong(this.getID());
    }

    public boolean isSimilar(Emote other) {
        if (other.isCustom() && this.isCustom() && this.getEmote() != null && other.getEmote() != null) {
            return this.getEmote().getName().equals(other.getEmote().getName());
        }
        if (!other.isCustom() && !this.isCustom() && this.getEmoji() != null && other.getEmoji() != null) {
            return this.getEmoji().getName().equals(other.getEmoji().getName());
        }
        return false;
    }
}

