/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.emojis;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.itsthesky.disky.api.emojis.Emoji;
import net.itsthesky.disky.api.emojis.HttpUtils;

public final class ExtendedEmoji {
    private static final String BASE_URL = "https://emojipedia.org/";
    private static final Pattern NAME_PATTERN = Pattern.compile("<h1><span class=\"emoji\">.*?</span> (.*)</h1>");
    private final Emoji emoji;
    private final String name;

    private ExtendedEmoji(Emoji emoji, String name) {
        this.emoji = emoji;
        this.name = name;
    }

    public static ExtendedEmoji of(Emoji emoji) throws IOException {
        String body = HttpUtils.getPageBody(BASE_URL + emoji.subpage());
        Matcher nameMatcher = NAME_PATTERN.matcher(body);
        if (!nameMatcher.find()) {
            throw new IllegalArgumentException("Name of the emoji " + emoji.unicode() + " aka " + String.valueOf(emoji.shortcodes()) + " not found");
        }
        return new ExtendedEmoji(emoji, nameMatcher.group(1));
    }

    public Emoji getEmoji() {
        return this.emoji;
    }

    public String getName() {
        return this.name;
    }
}

