/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.events;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.dv8tion.jda.api.audit.ActionType;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.guild.GuildAuditLogEntryCreateEvent;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.events.EventListener;
import net.itsthesky.disky.api.events.SimpleDiSkyEvent;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import net.itsthesky.disky.managers.CoreEventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiSkyEvent<D extends Event>
extends SelfRegisteringSkriptEvent {
    private static final Map<Class<? extends DiSkyEvent<?>>, Class<? extends SimpleDiSkyEvent<?>>> externalEventMap = new HashMap();
    public static final String APPENDED_ENDING = "[seen by %-string%]";
    private final Map<Class<?>, Object> valueMap = new HashMap();
    private String stringRepresentation;
    private Trigger trigger;
    private EventListener<D> listener;
    private String bot;
    private Class<? extends org.bukkit.event.Event> bukkitClass;
    private Class<D> jdaClass;
    private String originalName;
    private Class<? extends org.bukkit.event.Event>[] originalEvents;
    private Constructor<?> constructor;

    public static <T extends Event, D extends DiSkyEvent<T>, B extends SimpleDiSkyEvent<T>> void registerExternalEventClass(Class<D> diSkyEventClass, Class<B> bukkitEventClass) {
        externalEventMap.put(diSkyEventClass, bukkitEventClass);
    }

    public static SkriptEventInfo<?> register(String name, Class type, Class clazz, String ... patterns) {
        return DiSkyEvent.register(name, APPENDED_ENDING, type, clazz, patterns);
    }

    public static <T extends SimpleDiSkyEvent<?>> SkriptEventInfo<?> register(String name, String ending, Class type, Class<T> clazz, String ... patterns) {
        if (type.getName().contains("Generated")) {
            DiSkyEvent.registerExternalEventClass(type, clazz);
        }
        int i = 0;
        while (i < patterns.length) {
            int n = i++;
            patterns[n] = patterns[n] + " " + ending;
        }
        return Skript.registerEvent((String)name, (Class)type, clazz, (String[])patterns);
    }

    protected Predicate<D> checker() {
        return e -> true;
    }

    protected Predicate<GuildAuditLogEntryCreateEvent> logChecker() {
        return e -> true;
    }

    public boolean init(Literal<?> @NotNull [] exprs, int matchedPattern, @NotNull SkriptParser.ParseResult parser) {
        this.bot = (String)(exprs[0] == null ? null : exprs[0].getSingle());
        if (externalEventMap.containsKey(((Object)((Object)this)).getClass())) {
            this.bukkitClass = externalEventMap.get(((Object)((Object)this)).getClass());
            try {
                this.jdaClass = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            }
            catch (ClassCastException e) {
                throw new RuntimeException(((Object)((Object)this)).getClass().getCanonicalName() + " doesn't use a valid JDA event type. Report this at https://github.com/SkyCraft78/DiSky3/issues!");
            }
            try {
                this.constructor = this.bukkitClass.getDeclaredConstructor(DiSkyEvent.class);
            }
            catch (NoSuchMethodException e) {
                DiSky.debug("No constructor found for " + this.bukkitClass.getName() + " with DiSkyEvent parameter. Looking for empty constructor...");
                try {
                    this.constructor = this.bukkitClass.getDeclaredConstructor(new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    throw new RuntimeException("No suitable constructor found for " + this.bukkitClass.getName());
                }
            }
        } else {
            this.bukkitClass = Arrays.stream(((Object)((Object)this)).getClass().getDeclaredClasses()).filter(innerClass -> innerClass.getSuperclass() == SimpleDiSkyEvent.class).findFirst().orElse(null);
            if (this.bukkitClass == null) {
                throw new RuntimeException(((Object)((Object)this)).getClass().getCanonicalName() + " doesn't have an inner SimpleDiSkyEvent class to be instantiated. Report this at https://github.com/SkyCraft78/DiSky3/issues!");
            }
            try {
                this.jdaClass = (Class)((ParameterizedType)this.bukkitClass.getGenericSuperclass()).getActualTypeArguments()[0];
            }
            catch (ClassCastException e) {
                throw new RuntimeException(((Object)((Object)this)).getClass().getCanonicalName() + "'s inner class doesn't use the same JDA event as it's parent class in it's SimpleDiSkyEvent. Report this at https://github.com/SkyCraft78/DiSky3/issues!");
            }
            try {
                this.constructor = this.bukkitClass.getDeclaredConstructor(((Object)((Object)this)).getClass());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Constructor not found for " + this.bukkitClass.getName(), e);
            }
        }
        this.stringRepresentation = ScriptLoader.replaceOptions((String)SkriptLogger.getNode().getKey()) + ":";
        this.originalName = this.getParser().getCurrentEventName();
        this.originalEvents = this.getParser().getCurrentEvents();
        String name = null;
        for (SkriptEventInfo event : Skript.getEvents()) {
            if (!this.bukkitClass.equals(event.getElementClass())) continue;
            name = event.getName();
        }
        this.getParser().setCurrentEvent(name == null ? "DiSky event" : name, new Class[]{this.bukkitClass});
        return true;
    }

    public void afterParse(@NotNull Config config) {
        this.getParser().setCurrentEvent(this.originalName, (Class[])this.originalEvents);
    }

    public void register(@NotNull Trigger t) {
        this.trigger = t;
        this.listener = new EventListener<Event>(this.jdaClass, (JDAEvent, auditLogEntryCreateEvent) -> {
            if (this.check(JDAEvent)) {
                SimpleDiSkyEvent eventWorkaround = null;
                try {
                    eventWorkaround = this.constructor.getParameterCount() == 1 ? (SimpleDiSkyEvent)((Object)((Object)this.constructor.newInstance(new Object[]{this}))) : (SimpleDiSkyEvent)((Object)((Object)this.constructor.newInstance(new Object[0])));
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    DiSkyRuntimeHandler.error(new RuntimeException("Failed to instantiate event: " + e.getMessage(), e), SkriptLogger.getNode());
                    return;
                }
                SimpleDiSkyEvent event = eventWorkaround;
                event.setJDAEvent(JDAEvent);
                event.setLogEvent((GuildAuditLogEntryCreateEvent)auditLogEntryCreateEvent);
                SkriptUtils.sync(() -> {
                    if (this.getTrigger() != null) {
                        this.getTrigger().execute((org.bukkit.event.Event)event);
                    }
                });
            }
        }, this.checker(), this.logChecker(), this.getLogType(), this.bot, this.getParser().getNode());
        CoreEventListener.addListener(this.listener);
    }

    public void unregister(@NotNull Trigger t) {
        if (this.listener != null) {
            this.listener.enabled = false;
            CoreEventListener.removeListener(this.listener);
        }
        this.listener = null;
        this.trigger = null;
    }

    public void unregisterAll() {
        if (this.trigger != null) {
            this.unregister(this.trigger);
        }
    }

    @NotNull
    public String toString(@NotNull org.bukkit.event.Event e, boolean debug) {
        return this.stringRepresentation;
    }

    public String getBot() {
        return this.bot;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public boolean check(D event) {
        return this.bot == null || this.bot.equalsIgnoreCase(DiSky.getManager().getJDAName(((Event)event).getJDA()));
    }

    @Nullable
    public ActionType getLogType() {
        return null;
    }

    public Class<? extends org.bukkit.event.Event> getBukkitClass() {
        return this.bukkitClass;
    }

    public Class<D> getJDAClass() {
        return this.jdaClass;
    }

    public static Class<? extends Event> getDiSkyEventType(Class<DiSkyEvent<?>> clazz) {
        try {
            return (Class)((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (ClassCastException e) {
            throw new RuntimeException(clazz.getCanonicalName() + " doesn't use the same JDA event as it's parent class.");
        }
    }
}

