/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.events.rework;

import java.lang.reflect.Method;
import net.dv8tion.jda.api.events.Event;
import net.itsthesky.disky.api.events.DiSkyEvent;
import net.itsthesky.disky.api.events.SimpleDiSkyEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuiltEvent<T extends Event> {
    private final Class<T> jdaEventClass;
    private final Class<? extends DiSkyEvent<T>> diskyEventClass;
    private final Class<? extends org.bukkit.event.Event> bukkitEventClass;

    BuiltEvent(Class<T> jdaEventClass, Class<? extends DiSkyEvent<T>> diskyEventClass, Class<? extends org.bukkit.event.Event> bukkitEventClass) {
        this.jdaEventClass = jdaEventClass;
        this.diskyEventClass = diskyEventClass;
        this.bukkitEventClass = bukkitEventClass;
    }

    public Class<T> getJdaEventClass() {
        return this.jdaEventClass;
    }

    public Class<? extends DiSkyEvent<T>> getDiSkyEventClass() {
        return this.diskyEventClass;
    }

    public Class<? extends org.bukkit.event.Event> getBukkitEventClass() {
        return this.bukkitEventClass;
    }

    public org.bukkit.event.Event createBukkitInstance(Event jdaEvent) {
        try {
            org.bukkit.event.Event event = this.bukkitEventClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = SimpleDiSkyEvent.class.getDeclaredMethod("setJDAEvent", Event.class);
            method.invoke((Object)event, jdaEvent);
            return event;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create Bukkit event instance", e);
        }
    }

    @Nullable
    public T getJDAEvent(@NotNull org.bukkit.event.Event bukkitEvent) {
        if (bukkitEvent.getClass() != this.bukkitEventClass) {
            return null;
        }
        try {
            Method method = SimpleDiSkyEvent.class.getDeclaredMethod("getJDAEvent", new Class[0]);
            return (T)((Event)method.invoke((Object)bukkitEvent, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get JDA event instance", e);
        }
    }

    public DiSkyEvent<T> createDiSkyEvent() {
        try {
            return this.diskyEventClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create DiSky event instance", e);
        }
    }
}

