/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.events.rework;

import ch.njol.skript.registrations.Classes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.concrete.ForumChannel;
import net.dv8tion.jda.api.entities.channel.concrete.NewsChannel;
import net.dv8tion.jda.api.entities.channel.concrete.PrivateChannel;
import net.dv8tion.jda.api.entities.channel.concrete.StageChannel;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.guild.GuildAuditLogEntryCreateEvent;
import net.dv8tion.jda.api.events.interaction.GenericInteractionCreateEvent;
import net.dv8tion.jda.api.interactions.components.ComponentInteraction;
import net.dv8tion.jda.api.modals.Modal;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ModalCallbackAction;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.events.rework.BuiltEvent;
import net.itsthesky.disky.api.events.rework.CopyEventCategory;
import net.itsthesky.disky.api.events.rework.EventCategory;
import net.itsthesky.disky.api.events.rework.EventListExpressionRegistration;
import net.itsthesky.disky.api.events.rework.EventRegistryFactory;
import net.itsthesky.disky.api.events.rework.EventSingleExpressionRegistration;
import net.itsthesky.disky.api.events.rework.EventValueRegistration;
import net.itsthesky.disky.api.events.rework.InterfaceRegistration;
import net.itsthesky.disky.api.events.rework.RestValueRegistration;
import net.itsthesky.disky.api.events.specific.ComponentInteractionEvent;
import net.itsthesky.disky.api.events.specific.InteractionEvent;
import net.itsthesky.disky.api.events.specific.LogEvent;
import net.itsthesky.disky.api.events.specific.MessageEvent;
import net.itsthesky.disky.api.events.specific.ModalEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventBuilder<T extends Event> {
    public static final List<EventBuilder<?>> REGISTERED_EVENTS = new ArrayList();
    private final Class<T> jdaEventClass;
    @Nullable
    private EventCategory eventCategory;
    private String name;
    private String[] patterns;
    private boolean skriptRegistered = true;
    private final List<String> descriptionLines = new ArrayList<String>();
    private final List<String> exampleLines = new ArrayList<String>();
    final List<EventValueRegistration<T, ?>> valueRegistrations = new ArrayList();
    final List<EventSingleExpressionRegistration<T, ?>> singleExpressionRegistrations = new ArrayList();
    final List<EventListExpressionRegistration<T, ?>> listExpressionRegistrations = new ArrayList();
    final List<RestValueRegistration<T, ?, ?>> restValueRegistrations = new ArrayList();
    final List<InterfaceRegistration<T, ?, ?, ?>> interfaces = new ArrayList();
    @Nullable
    private Function<T, Boolean> isCancelledMapper;
    @Nullable
    private BiConsumer<T, Boolean> setCancelledMapper;
    private Function<T, Guild> authorMapper;
    private Predicate<T> checker;
    private Predicate<GuildAuditLogEntryCreateEvent> logChecker;

    EventBuilder(Class<T> jdaEventClass) {
        this.jdaEventClass = jdaEventClass;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length > 3) {
            String className = stackTrace[3].getClassName();
            try {
                CopyEventCategory copy;
                Class<?> callingClass = Class.forName(className);
                this.eventCategory = callingClass.getAnnotation(EventCategory.class);
                if (this.eventCategory == null && (copy = callingClass.getAnnotation(CopyEventCategory.class)) != null) {
                    this.eventCategory = copy.value().getAnnotation(EventCategory.class);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not find calling class", e);
            }
        }
    }

    public EventBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public EventBuilder<T> patterns(String ... patterns) {
        this.patterns = patterns;
        return this;
    }

    public EventBuilder<T> noRegistration() {
        this.skriptRegistered = false;
        return this;
    }

    public EventBuilder<T> eventCategory(Class<?> eventCategory) {
        this.eventCategory = eventCategory.getAnnotation(EventCategory.class);
        return this;
    }

    public EventBuilder<T> cancellable(@NotNull Function<T, Boolean> isCancelledMapper, @NotNull BiConsumer<T, Boolean> setCancelledMapper) {
        this.isCancelledMapper = isCancelledMapper;
        this.setCancelledMapper = setCancelledMapper;
        return this;
    }

    public EventBuilder<T> description(String line) {
        this.descriptionLines.add(line.replace("    ", "    "));
        return this;
    }

    public EventBuilder<T> description(String ... lines) {
        for (String line : lines) {
            this.descriptionLines.add(line.replace("    ", "    "));
        }
        return this;
    }

    public EventBuilder<T> example(String example) {
        this.exampleLines.add(example.replace("    ", "    "));
        return this;
    }

    public EventBuilder<T> examples(String ... examples) {
        for (String example : examples) {
            this.exampleLines.add(example.replace("    ", "    "));
        }
        return this;
    }

    public <I, R, P> EventBuilder<T> implement(Class<I> interfaceClass, Class<R> returnTypeClass, @Nullable Class<P> parameterTypeClass, String methodName, BiFunction<P, T, R> function) {
        this.interfaces.add(new InterfaceRegistration<T, I, R, P>(interfaceClass, returnTypeClass, parameterTypeClass, methodName, function));
        return this;
    }

    public EventBuilder<T> implementModal(BiFunction<T, Modal, ModalCallbackAction> modalMapper) {
        this.description("", "!!! info \"You can reply with a **modal** in this event.\"");
        return this.implement(ModalEvent.class, ModalCallbackAction.class, Modal.class, "replyModal", (modal, event) -> (ModalCallbackAction)modalMapper.apply((Object)event, (Modal)modal));
    }

    public EventBuilder<T> implementInteraction(Function<T, GenericInteractionCreateEvent> interactionMapper) {
        return this.implement(InteractionEvent.class, GenericInteractionCreateEvent.class, null, "getInteractionEvent", (none, event) -> (GenericInteractionCreateEvent)interactionMapper.apply(event));
    }

    public EventBuilder<T> implementMessage(Function<T, MessageChannel> messageMapper) {
        return this.implement(MessageEvent.class, MessageChannel.class, null, "getMessageChannel", (none, event) -> (MessageChannel)messageMapper.apply(event));
    }

    public EventBuilder<T> implementLog(Function<T, User> authorMapper) {
        return this.implement(LogEvent.class, User.class, null, "getActionAuthor", (none, event) -> (User)authorMapper.apply(event));
    }

    public EventBuilder<T> implementComponentInteraction(Function<T, ComponentInteraction> interactionMapper) {
        return this.implement(ComponentInteractionEvent.class, ComponentInteraction.class, null, "getInteractionEvent", (none, event) -> (ComponentInteraction)interactionMapper.apply(event));
    }

    public EventBuilder<T> checker(Predicate<T> checker) {
        this.checker = checker;
        return this;
    }

    public EventBuilder<T> logChecker(Predicate<GuildAuditLogEntryCreateEvent> checker) {
        this.logChecker = checker;
        return this;
    }

    public <V> EventBuilder<T> value(Class<V> valueClass, Function<T, V> mapper) {
        return this.value(valueClass, mapper, 0);
    }

    public EventBuilder<T> channelValues(Function<T, Channel> channelMapper) {
        this.value(Channel.class, channelMapper);
        this.value(MessageChannel.class, channelMapper.andThen(channel -> channel.getType().isMessage() ? (MessageChannel)channel : null));
        this.value(AudioChannel.class, channelMapper.andThen(channel -> channel.getType().isAudio() ? (AudioChannel)channel : null));
        this.value(VoiceChannel.class, channelMapper.andThen(channel -> channel.getType().isGuild() && channel.getType().equals((Object)ChannelType.VOICE) ? (VoiceChannel)channel : null));
        this.value(StageChannel.class, channelMapper.andThen(channel -> channel.getType().isGuild() && channel.getType().equals((Object)ChannelType.STAGE) ? (StageChannel)channel : null));
        this.value(PrivateChannel.class, channelMapper.andThen(channel -> !channel.getType().isGuild() ? (PrivateChannel)channel : null));
        this.value(GuildChannel.class, channelMapper.andThen(channel -> channel.getType().isGuild() ? (GuildChannel)channel : null));
        this.value(TextChannel.class, channelMapper.andThen(channel -> channel.getType().isGuild() && channel.getType().equals((Object)ChannelType.TEXT) ? (TextChannel)channel : null));
        this.value(NewsChannel.class, channelMapper.andThen(channel -> channel.getType().isGuild() && channel.getType().equals((Object)ChannelType.NEWS) ? (NewsChannel)channel : null));
        this.value(ThreadChannel.class, channelMapper.andThen(channel -> channel.getType().isGuild() && channel.getType().isThread() ? (ThreadChannel)channel : null));
        this.value(ForumChannel.class, channelMapper.andThen(channel -> channel.getType().isGuild() && channel.getType().equals((Object)ChannelType.FORUM) ? (ForumChannel)channel : null));
        return this;
    }

    public <V> EventBuilder<T> value(Class<V> valueClass, Function<T, V> mapper, int time) {
        this.valueRegistrations.add(new EventValueRegistration<T, V>(valueClass, mapper, time));
        return this;
    }

    public <V> EventBuilder<T> pastValue(Class<V> valueClass, Function<T, V> mapper) {
        return this.value(valueClass, mapper, -1);
    }

    public <V> EventBuilder<T> futureValue(Class<V> valueClass, Function<T, V> mapper) {
        return this.value(valueClass, mapper, 1);
    }

    public <E> EventBuilder<T> singleExpression(String pattern, Class<E> expressionClass, Function<T, E> mapper) {
        this.singleExpressionRegistrations.add(new EventSingleExpressionRegistration<T, E>(pattern, expressionClass, mapper));
        return this;
    }

    public <E> EventBuilder<T> customTimedExpressions(String baseProperty, Class<E> expressionClass, Function<T, E> currentMapper, Function<T, E> pastMapper) {
        this.singleExpression("[(new|current)] " + baseProperty, expressionClass, currentMapper);
        this.singleExpression("(old|past|previous) " + baseProperty, expressionClass, pastMapper);
        return this;
    }

    public <E> EventBuilder<T> customTimedListExpressions(String baseProperty, Class<E> expressionClass, Function<T, E[]> currentMapper, Function<T, E[]> pastMapper) {
        this.listExpression("[(new|current)] " + baseProperty, expressionClass, currentMapper);
        this.listExpression("(old|past|previous) " + baseProperty, expressionClass, pastMapper);
        return this;
    }

    public <E> EventBuilder<T> listExpression(String pattern, Class<E> expressionClass, Function<T, E[]> mapper) {
        this.listExpressionRegistrations.add(new EventListExpressionRegistration<T, E>(pattern, expressionClass, mapper));
        return this;
    }

    public EventBuilder<T> author(Function<T, Guild> mapper) {
        this.authorMapper = mapper;
        return this;
    }

    public <A> EventBuilder<T> restValue(String codeName, Function<T, RestAction<A>> actionMapper) {
        this.restValueRegistrations.add(new RestValueRegistration(codeName, actionMapper));
        return this;
    }

    public <A, R> EventBuilder<T> restValue(String codeName, Function<T, RestAction<A>> actionMapper, Function<A, R> resultMapper) {
        this.restValueRegistrations.add(new RestValueRegistration<T, A, R>(codeName, actionMapper, resultMapper));
        return this;
    }

    public BuiltEvent<T> register() {
        if ((this.name == null || this.patterns == null) && this.skriptRegistered) {
            throw new IllegalStateException("Event name and patterns must be set before registering.");
        }
        REGISTERED_EVENTS.add(this);
        return EventRegistryFactory.registerEvent(this);
    }

    @Nullable
    public EventCategory getCategory() {
        return this.eventCategory;
    }

    @Nullable
    public String createDocumentation() {
        String codeName;
        Class<Object> clazz;
        if (!this.skriptRegistered) {
            return null;
        }
        StringBuilder documentation = new StringBuilder();
        documentation.append(this.getCategory() == null ? "## " : "### ").append(this.name).append("\n\n");
        documentation.append("[[[ macros.required_version('").append(DiSky.getVersion()).append("') ]]]\n");
        documentation.append("[[[ macros.is_cancellable('No') ]]]\n\n");
        if (!this.descriptionLines.isEmpty()) {
            documentation.append(this.descriptionLines.stream().reduce((a, b) -> a + "\n" + b).orElse("")).append("\n\n");
        } else {
            documentation.append("No description provided.\n\n");
        }
        documentation.append("=== \"Examples\"\n");
        documentation.append("    ```applescript\n");
        if (this.exampleLines.isEmpty()) {
            documentation.append("    No examples provided.\n");
        } else {
            documentation.append(this.exampleLines.stream().map(line -> "    " + line).reduce((a, b) -> a + "\n" + b).orElse("")).append("\n");
        }
        documentation.append("    ```\n\n");
        documentation.append("=== \"Patterns\"\n");
        documentation.append("    ```applescript\n");
        documentation.append(Arrays.stream(this.patterns).map(line -> "    " + line).reduce((a, b) -> a + "\n" + b).orElse("")).append("\n");
        documentation.append("    ```\n\n");
        documentation.append("=== \"Event Values\"\n");
        for (EventSingleExpressionRegistration<T, ?> eventSingleExpressionRegistration : this.singleExpressionRegistrations) {
            clazz = eventSingleExpressionRegistration.getExpressionClass();
            codeName = Classes.getExactClassName(clazz);
            documentation.append("    * `").append(eventSingleExpressionRegistration.getPattern()).append("` - Returns a `").append(codeName).append("`.").append("\n");
        }
        for (EventListExpressionRegistration eventListExpressionRegistration : this.listExpressionRegistrations) {
            clazz = eventListExpressionRegistration.getExpressionClass();
            codeName = Classes.getExactClassName(clazz);
            documentation.append("    * `").append(eventListExpressionRegistration.getPattern()).append("` - Returns a list of `").append(codeName).append("`.").append("\n");
        }
        for (EventValueRegistration eventValueRegistration : this.valueRegistrations) {
            clazz = eventValueRegistration.getValueClass();
            codeName = Classes.getExactClassName(clazz);
            String prefix = eventValueRegistration.getTime() == 0 ? "" : (eventValueRegistration.getTime() == -1 ? "past " : "future ");
            documentation.append("    * [`").append(prefix).append("event-").append(codeName).append("`](../docs/types.md#").append(codeName).append(")").append("\n");
        }
        if (!this.restValueRegistrations.isEmpty()) {
            documentation.append("\n=== \"REST/Retrieve Event Values\"\n\n");
            documentation.append("    !!! info \"Check the [retrieve values docs](#information-retrieve-values)!\"\n\n");
            for (RestValueRegistration restValueRegistration : this.restValueRegistrations) {
                String codeName2 = restValueRegistration.getCodeName();
                documentation.append("    * `").append(codeName2).append("`\n");
            }
        }
        documentation.append("\n\n");
        return documentation.toString();
    }

    String getName() {
        return this.name == null ? this.jdaEventClass.getSimpleName() : this.name;
    }

    String[] getPatterns() {
        return this.patterns;
    }

    String[] getDescriptionLines() {
        return this.descriptionLines.toArray(new String[0]);
    }

    String[] getExampleLines() {
        return this.exampleLines.toArray(new String[0]);
    }

    List<InterfaceRegistration<T, ?, ?, ?>> getInterfaces() {
        return this.interfaces;
    }

    List<EventValueRegistration<T, ?>> getValueRegistrations() {
        return this.valueRegistrations;
    }

    List<RestValueRegistration<T, ?, ?>> getRestValueRegistrations() {
        return this.restValueRegistrations;
    }

    Function<T, Guild> getAuthorMapper() {
        return this.authorMapper;
    }

    Class<T> getJdaEventClass() {
        return this.jdaEventClass;
    }

    Predicate<T> getChecker() {
        return this.checker;
    }

    Predicate<GuildAuditLogEntryCreateEvent> getLogChecker() {
        return this.logChecker;
    }

    List<EventSingleExpressionRegistration<T, ?>> getSingleExpressionRegistrations() {
        return this.singleExpressionRegistrations;
    }

    List<EventListExpressionRegistration<T, ?>> getListExpressionRegistrations() {
        return this.listExpressionRegistrations;
    }

    boolean isCancellable() {
        return this.isCancelledMapper != null && this.setCancelledMapper != null;
    }

    @Nullable
    Function<T, Boolean> getIsCancelledMapper() {
        return this.isCancelledMapper;
    }

    @Nullable
    BiConsumer<T, Boolean> getSetCancelledMapper() {
        return this.setCancelledMapper;
    }

    boolean isSkriptRegistered() {
        return this.skriptRegistered;
    }
}

